/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.property;

import com.silabs.ss.framework.project.api.core.property.IDefine;
import com.silabs.ss.framework.project.internal.core.property.Define;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DefineFactory {
    private static final Pattern MACRO_SPLIT_PATTERN = Pattern.compile("\\s*([A-Za-z0-9_]+(?:\\([ \tA-Za-z0-9_,]*\\))?)(\\s+|=)\\s*(.*)");

    private DefineFactory() {
    }

    public static IDefine createDefine(String macroName) {
        return new Define(macroName, null, null);
    }

    public static IDefine createDefine(String macroPrototype, String expansion) {
        int fidx = macroPrototype.indexOf(40);
        int lidx = macroPrototype.indexOf(41, fidx);
        if (fidx >= 0 && lidx > fidx) {
            String[] args = macroPrototype.substring(fidx + 1, lidx).split(",");
            return new Define(macroPrototype.substring(0, fidx).trim(), args, expansion);
        }
        return new Define(macroPrototype, null, expansion);
    }

    public static IDefine createDefine(String macroName, String[] macroArgs, String expansion) {
        return new Define(macroName, macroArgs, expansion);
    }

    public static IDefine createSimpleFreeformDefine(String macro) {
        Matcher matcher = MACRO_SPLIT_PATTERN.matcher(macro);
        if (matcher.matches()) {
            if (matcher.group(2).length() > 0) {
                return DefineFactory.createDefine(matcher.group(1), matcher.group(3).trim());
            }
            if (matcher.group(3).length() > 0) {
                return DefineFactory.createDefine(matcher.group(1), matcher.group(3).trim());
            }
        }
        return DefineFactory.createDefine(macro.trim());
    }
}

