/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.solution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectWithBuildConfigurationId;
import com.silabs.ss.framework.project.api.core.solution.IProjectSolutionTemplateContext;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.SolutionFactory;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.utils.SolutionUpdateUtils;
import com.silabs.ss.framework.project.api.templates.ISolutionTemplateContext;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateContext;
import com.silabs.ss.framework.project.api.templates.solution.ISolutionTemplate;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public final class NewSolutionTemplateHelper {
    private final INewProjectDescriptor solutionProject;
    private final ISolutionTemplate solutionTemplate;
    private final SolutionFactory.CreateSolution solutionFactory;
    private final ImmutableMap<String, INewProjectDescriptor> subProjects;
    private final IWriteableProjectDescriptor[] subProjectsArr;
    private TemplateContextData contextData;

    public static NewSolutionTemplateHelper create(IWriteableProjectDescriptor ... projects) {
        return new NewSolutionTemplateHelper(projects);
    }

    private NewSolutionTemplateHelper(IWriteableProjectDescriptor ... projects) {
        this.solutionProject = this.loadSolutionProject(projects);
        this.solutionTemplate = this.loadSolutionTemplate();
        this.subProjects = this.loadSubProjects(this.solutionProject, this.solutionTemplate);
        this.subProjectsArr = this.subProjects.isEmpty() ? projects : (IWriteableProjectDescriptor[])this.subProjects.values().toArray(IWriteableProjectDescriptor[]::new);
        this.solutionFactory = this.loadSolutionFactory(this.solutionProject);
    }

    public boolean isSolution() {
        return this.solutionProject != null;
    }

    public IWriteableProjectDescriptor solutionProject() {
        return this.solutionProject;
    }

    public ISolutionTemplate solutionTemplate() {
        return this.solutionTemplate;
    }

    public IWriteableProjectDescriptor[] projects() {
        this.updateSubProjects();
        return this.subProjectsArr;
    }

    public Collection<IWriteableProjectDescriptor> allProjects() {
        return Stream.concat(Stream.of(this.solutionProject), Stream.of(this.subProjectsArr)).flatMap(arg_0 -> ((Caster)Caster.with(IWriteableProjectDescriptor.class)).stream(arg_0)).toList();
    }

    public SolutionFactory.CreateSolution solution() {
        this.updateSolutionFactory();
        return this.solutionFactory;
    }

    public IPath getInitialResource() {
        if (!this.isSolution()) {
            return null;
        }
        return this.resolveResource(this.solutionTemplate.getInitiallyOpenedResource());
    }

    public List<IPath> getInitialFiles() {
        if (!this.isSolution()) {
            return Collections.emptyList();
        }
        return this.solutionTemplate.getInitiallyRevealedFiles().stream().map(this::resolveResource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void runPreSolutionProcess(IProgressMonitor monitor) throws CoreException {
        if (!this.isSolution()) {
            return;
        }
        this.solutionTemplate().executePreTemplateProcess((ISolutionTemplateContext)this.contextData(), monitor);
    }

    public void injectSolutionData(ITemplateContext context) throws CoreException {
        if (!this.isSolution()) {
            return;
        }
        context.getObjectMap().putAll(this.contextData().getObjectMap());
        context.getVariableMap().putAll(this.contextData().getVariableMap());
    }

    public void runSolutionProcess(IProgressMonitor monitor) throws CoreException {
        if (!this.isSolution()) {
            return;
        }
        this.solutionTemplate().executeTemplateProcesses((ITemplateContext)this.contextData(), monitor);
    }

    private TemplateContextData contextData() throws CoreException {
        if (this.contextData == null) {
            ISolutionDescriptor slnDesc = ISolutionDescriptor.create(this.solutionProject().getName());
            ((IWriteableDescriptor)slnDesc).setProperty(CoreProperties.INSTALLATION_PATH, (Object)((URI)this.solutionProject().getProperty(CoreProperties.INSTALLATION_PATH)));
            try {
                File outputDir = this.solutionProject.getInstallationPath().toFile();
                ISolutionEntity slnEntity = SolutionUpdateUtils.loadSolutionEntity(this.solutionProject.getProjectType(), slnDesc, outputDir).map(Pair::first).orElseThrow(IOException::new);
                this.contextData = new TemplateContextData(slnEntity);
            }
            catch (IOException e) {
                throw Activator.reporter.newCoreException("Failed to load the Solution for " + slnDesc.getName(), (Throwable)e);
            }
        }
        return this.contextData;
    }

    public <T> InitialResources<T> resolveResources(Function<IPath, T> func) {
        if (!this.isSolution()) {
            return new InitialResources<Object>(null, ImmutableList.of());
        }
        return new InitialResources<T>(func.apply(this.getInitialResource()), (ImmutableList)this.getInitialFiles().stream().map(func).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
    }

    private IPath resolveResource(String rsrcPath) {
        if (TextUtils.isEmpty((String)rsrcPath)) {
            return null;
        }
        String[] rsrcPathArr = new String[]{rsrcPath};
        this.subProjects.forEach((t, p) -> {
            String string = rsrcPathArr[0].replace((CharSequence)t, p.getName());
        });
        return IPathUtils.createPath((String)rsrcPathArr[0]);
    }

    private void updateSubProjects() {
        if (!this.isSolution()) {
            return;
        }
        Map<String, ProjectWithBuildConfigurationId> bConfDeps = this.subProjects.values().stream().flatMap(dep -> dep.buildConfigurationDescriptors().stream()).collect(Collectors.toMap(this::calculateId, ProjectWithBuildConfigurationId::new));
        this.subProjects.forEach((t, p) -> {
            for (IBuildConfigurationDescriptor bconf : p.buildConfigurationDescriptors()) {
                List<ProjectWithBuildConfigurationId> depsList = this.solutionTemplate.getLinkedProjects(t).stream().map(arg_0 -> this.subProjects.get(arg_0)).map(dep -> (ProjectWithBuildConfigurationId)bConfDeps.get(this.calculateId((IProjectDescriptor)dep, bconf))).collect(Collectors.toList());
                bconf.setProjectDependencies(depsList);
            }
        });
    }

    private String calculateId(IBuildConfigurationDescriptor bconf) {
        return this.calculateId((IProjectDescriptor)bconf.getParent(), bconf);
    }

    private String calculateId(IProjectDescriptor project, IBuildConfigurationDescriptor bconf) {
        return project.getName() + "%%" + bconf.getName();
    }

    private INewProjectDescriptor loadSolutionProject(IWriteableProjectDescriptor ... projectDescs) {
        if (projectDescs.length != 1) {
            return null;
        }
        if (!(projectDescs[0] instanceof INewProjectDescriptor)) {
            return null;
        }
        INewProjectDescriptor proj = (INewProjectDescriptor)projectDescs[0];
        if (!(proj.getTemplate() instanceof ISolutionTemplate)) {
            return null;
        }
        return proj;
    }

    private ISolutionTemplate loadSolutionTemplate() {
        if (this.solutionProject == null) {
            return null;
        }
        return (ISolutionTemplate)this.solutionProject.getTemplate();
    }

    private ImmutableMap<String, INewProjectDescriptor> loadSubProjects(INewProjectDescriptor solutionProj, ISolutionTemplate solutionTemplate) {
        if (solutionProj == null || solutionTemplate == null) {
            return ImmutableMap.of();
        }
        solutionProj.getCurrentConfigurationDescriptor();
        ImmutableMap newProjs = (ImmutableMap)solutionTemplate.getProjectTemplates().stream().filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(IDescribable::getId, t -> {
            INewProjectDescriptor newProj = solutionProj.copy();
            newProj.setTemplate((ITemplate)t);
            newProj.setName(t.getDefaultName());
            newProj.setProjectDescriptionLocationURI(null);
            return newProj;
        }));
        return newProjs;
    }

    private SolutionFactory.CreateSolution loadSolutionFactory(INewProjectDescriptor solutionProj) {
        if (solutionProj == null) {
            return null;
        }
        return new SolutionTemplateCreateSolution(solutionProj.getName());
    }

    private SolutionFactory.CreateSolution updateSolutionFactory() {
        if (!this.isSolution()) {
            return null;
        }
        if (this.solutionFactory.isReadOnly()) {
            return this.solutionFactory;
        }
        SolutionFactory.CreateSolution factory = (SolutionFactory.CreateSolution)((SolutionFactory.CreateSolution)this.solutionFactory.setName(this.solutionProject.getName())).setProjectNames(this.subProjects.values().stream().map(IDescribable::getName).collect(Collectors.toList()));
        for (String group : this.solutionTemplate.getConfigurations()) {
            SolutionFactory.CreateSolutionConfiguration fgroup = factory.configuration(group);
            fgroup.clearProjects();
            this.solutionTemplate.getConfigurationTemplateIds(group).stream().map(arg_0 -> this.subProjects.get(arg_0)).forEach(p -> this.setupSolutionProject(fgroup, (INewProjectDescriptor)p));
            fgroup.commit();
        }
        return factory;
    }

    private void setupSolutionProject(SolutionFactory.CreateSolutionConfiguration groupFactory, INewProjectDescriptor project) {
        if (project.getCurrentConfigurationDescriptor() == null) {
            return;
        }
        ((SolutionFactory.CreateSolutionConfigProject)groupFactory.project(project.getName()).setConfiguration(project.getCurrentConfigurationDescriptor().getName())).commit();
    }

    public class InitialResources<T> {
        public final T initiallyOpenedResource;
        public final ImmutableList<T> initiallyRevealedFiles;

        private InitialResources(T initiallyOpenedResource, ImmutableList<T> initiallyRevealedFiles) {
            this.initiallyOpenedResource = initiallyOpenedResource;
            this.initiallyRevealedFiles = initiallyRevealedFiles;
        }
    }

    private class SolutionTemplateCreateSolution
    extends SolutionFactory.CreateSolution {
        protected SolutionTemplateCreateSolution(MSolution model) {
            super(model);
        }

        protected SolutionTemplateCreateSolution(String name) {
            super(name);
        }

        @Override
        public SolutionFactory.CreateSolution setName(String name) {
            SolutionFactory.CreateSolution factory = (SolutionFactory.CreateSolution)super.setName(name);
            NewSolutionTemplateHelper.this.solutionProject().setName(factory.getName());
            return factory;
        }
    }

    private class TemplateContextData
    implements IProjectSolutionTemplateContext {
        private final Map<String, Object> dataMap = new HashMap<String, Object>();
        private final Map<String, String> variableMap = new HashMap<String, String>();
        private final ISolutionEntity slnEntity;

        private TemplateContextData(ISolutionEntity slnEntity) {
            this.slnEntity = slnEntity;
        }

        public Map<String, Object> getObjectMap() {
            return this.dataMap;
        }

        public Map<String, String> getVariableMap() {
            return this.variableMap;
        }

        @Override
        public IProjectDescriptor[] projects() {
            return NewSolutionTemplateHelper.this.projects();
        }

        @Override
        public IProjectDescriptor solutionProject() {
            return NewSolutionTemplateHelper.this.solutionProject();
        }

        @Override
        public ISolutionEntity solutionEntity() {
            return this.slnEntity;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }
}

