/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.solution;

import com.silabs.ss.framework.project.api.core.solution.BaseSolutionFactory;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.util.manual.SolutionModelLoading;
import java.nio.file.Path;

public class SolutionFactory {
    private SolutionFactory() {
    }

    public static CreateSolution create(String name) {
        CreateSolution newSolution = new CreateSolution(name);
        return newSolution;
    }

    public static CreateSolution edit(MSolution toEdit) {
        if (toEdit == null) {
            throw new IllegalArgumentException("Creating a solution should use the SlsSolutionFactory#create API");
        }
        return new CreateSolution(toEdit);
    }

    public static CreateSolution fromDisk(Path path) {
        MSolution solution = (MSolution)SolutionModelLoading.loadFrom((Path)path).findFirst().orElseThrow(() -> new IllegalArgumentException("No Solution found at " + String.valueOf(path)));
        return new CreateSolution(solution);
    }

    public static CreateSolutionModule module(String id) {
        return new CreateSolutionModule(id);
    }

    public static BaseSolutionFactory.SolutionProjectCreator forProject(String projectName) {
        return new BaseSolutionFactory.SolutionProjectCreator(projectName);
    }

    public static class CreateSolution
    extends BaseSolutionFactory.BaseCreateSolution<CreateSolution> {
        protected CreateSolution(MSolution model) {
            super(model);
        }

        protected CreateSolution(String name) {
            super(name);
        }

        public CreateSolutionConfiguration configuration(String configName) {
            return new CreateSolutionConfiguration(this, configName);
        }

        public CreateSolutionProject project(String projectName) {
            return new CreateSolutionProject(this, projectName);
        }
    }

    public static class CreateSolutionConfigProject
    extends BaseSolutionFactory.BaseCreateSolutionConfigProject<CreateSolutionConfigProject> {
        protected CreateSolutionConfigProject(CreateSolutionConfiguration parent, String projectName) {
            super(parent, projectName);
        }

        @Override
        public CreateSolutionConfiguration remove() {
            return (CreateSolutionConfiguration)super.remove();
        }

        @Override
        public CreateSolutionConfiguration commit() {
            return (CreateSolutionConfiguration)super.commit();
        }
    }

    public static class CreateSolutionConfiguration
    extends BaseSolutionFactory.BaseCreateSolutionConfiguration<CreateSolutionConfiguration> {
        protected CreateSolutionConfiguration(CreateSolution parent, String groupName) {
            super(parent, groupName);
        }

        public CreateSolutionConfigProject project(String projectName) {
            return new CreateSolutionConfigProject(this, projectName);
        }

        public CreateSolution commit() {
            return (CreateSolution)super.commit();
        }
    }

    public static class CreateSolutionModule
    extends BaseSolutionFactory.BaseCreateSolutionModule<CreateSolutionModule> {
        protected CreateSolutionModule(String id) {
            super(id);
        }

        public CreateSolutionModuleConfiguration configuration(String configName) {
            return new CreateSolutionModuleConfiguration(this, configName);
        }

        public CreateSolutionModuleProject project(String projectName) {
            return new CreateSolutionModuleProject(this, projectName);
        }
    }

    public static class CreateSolutionModuleConfigProject
    extends BaseSolutionFactory.BaseCreateSolutionConfigProject<CreateSolutionModuleConfigProject> {
        protected CreateSolutionModuleConfigProject(CreateSolutionModuleConfiguration parent, String projectName) {
            super(parent, projectName);
        }

        @Override
        public CreateSolutionModuleConfiguration commit() {
            return (CreateSolutionModuleConfiguration)super.commit();
        }
    }

    public static class CreateSolutionModuleConfiguration
    extends BaseSolutionFactory.BaseCreateSolutionConfiguration<CreateSolutionModuleConfiguration> {
        protected CreateSolutionModuleConfiguration(CreateSolutionModule parent, String groupName) {
            super(parent, groupName);
        }

        public CreateSolutionModuleConfigProject project(String projectName) {
            return new CreateSolutionModuleConfigProject(this, projectName);
        }

        public CreateSolutionModule commit() {
            return (CreateSolutionModule)super.commit();
        }
    }

    public static class CreateSolutionModuleProject
    extends BaseSolutionFactory.BaseCreateSolutionProject<CreateSolutionModuleProject> {
        protected CreateSolutionModuleProject(CreateSolutionModule parent, String projectName) {
            super(parent, projectName);
        }

        @Override
        public CreateSolutionModule commit() {
            return (CreateSolutionModule)super.commit();
        }
    }

    public static class CreateSolutionProject
    extends BaseSolutionFactory.BaseCreateSolutionProject<CreateSolutionProject> {
        protected CreateSolutionProject(CreateSolution parent, String projectName) {
            super(parent, projectName);
        }

        @Override
        public CreateSolution commit() {
            return (CreateSolution)super.commit();
        }
    }
}

