/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.templates;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngine;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectEngineOperationUtils;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.api.core.templates.IProjectModelTemplate;
import com.silabs.ss.framework.project.api.core.templates.IProjectModelTemplateContext;
import com.silabs.ss.framework.project.api.core.templates.IProjectTemplateSetupAdapter;
import com.silabs.ss.framework.project.api.core.templates.ProjectTemplateUtils;
import com.silabs.ss.framework.project.api.templates.BaseTemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateContext;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchain;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.templates.TemplateProjectEngineOperationHandler;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.IBoard;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import com.silabs.ss.platform.api.sdk.core.ISDK;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectModelTemplate
extends BaseTemplate
implements IProjectModelTemplate {
    private MProject model;
    private Long lastLoadedTimeStamp;

    public ProjectModelTemplate(ITemplateDescriptor desc, String providingBundleId) throws CoreException {
        super(desc, providingBundleId);
        ((IWriteableDescriptor)desc).setProperty(TemplateProperties.ALLOWS_EXISTING_LOCATION, (Object)true);
    }

    public String getDefaultName() {
        String name = super.getDefaultName();
        if (TextUtils.isEmpty((String)name)) {
            try {
                name = this.getMProject().getName();
            }
            catch (CoreException e) {
                Activator.reporter.logError("failed to instantiate project", (Throwable)e);
            }
        }
        if (TextUtils.isEmpty((String)name)) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public MProject getMProject() throws CoreException {
        if (!this.isSlsprojModel()) {
            return ProjectModelFactory.eINSTANCE.createMProject();
        }
        Long currentTimeStamp = (Long)this.getProperty(CoreProperties.TIME_STAMP);
        if (this.model == null || !Objects.equals(this.lastLoadedTimeStamp, currentTimeStamp)) {
            this.model = this.createModel();
            this.lastLoadedTimeStamp = currentTimeStamp;
        }
        return this.model;
    }

    @Override
    public void setMProject(MProject model) {
        this.model = model;
        this.setProperty(TemplateProperties.DEFAULT_NAME, model.getName());
        this.lastLoadedTimeStamp = (Long)this.getProperty(CoreProperties.TIME_STAMP);
    }

    protected void gatherDirs(List<File> dirs, File dir) {
        if (dir == null) {
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                dirs.add(file);
                this.gatherDirs(dirs, file);
            }
            ++n2;
        }
    }

    protected MProject createModel() throws CoreException {
        URI uri;
        MProject mainProject = null;
        URI sourceUri = (URI)((ITemplateDescriptor)this.getDescriptor()).getProperty(TemplateProperties.SOURCE_URI);
        if (sourceUri != null) {
            mainProject = ProjectModelFactory.eINSTANCE.createMProject();
            URI sourceRootUri = (URI)((ITemplateDescriptor)this.getDescriptor()).getProperty(TemplateProperties.SOURCE_ROOT_URI);
            mainProject.setContentRoot(sourceRootUri.toString());
            MFolderContent src = ProjectModelUtils.findOrCreateFolderContent(null, mainProject, (MFolderEntry)mainProject, "$(sourceDir)", sourceUri.toString());
            mainProject.getSourceFolders().add((Object)src.getName());
            String sourceFile = (String)((ITemplateDescriptor)this.getDescriptor()).getProperty(TemplateProperties.SOURCE_FILENAME);
            if (TextUtils.isEmpty((String)sourceFile)) {
                src.setIncludeAllFiles(true);
                src.setIncludeAllFolders(true);
                try {
                    File prjRoot = URIUtils.toFileWithRelative((URI)sourceRootUri);
                    File srcRoot = URIUtils.toFileWithRelative((URI)sourceUri);
                    ArrayList<File> inclDirs = new ArrayList<File>(1);
                    this.gatherDirs(inclDirs, srcRoot);
                    Path lead = new Path(prjRoot.getAbsolutePath());
                    for (File inclDir : inclDirs) {
                        MIncludePath inclSetting = ProjectModelFactory.eINSTANCE.createMIncludePath();
                        IPath incl = new Path(inclDir.getAbsolutePath()).makeRelativeTo((IPath)lead);
                        inclSetting.setUri("studio:/project/" + incl.toPortableString());
                        inclSetting.setUser(false);
                        mainProject.getIncludePaths().add((Object)inclSetting);
                    }
                }
                catch (IOException e) {
                    Activator.reporter.logError("failed to add #include path for " + String.valueOf(sourceUri), (Throwable)e);
                }
            } else {
                src.setIncludeAllFiles(false);
                src.setIncludeAllFolders(false);
                MFileContent file = ProjectModelFactory.eINSTANCE.createMFileContent();
                file.setName(sourceFile);
                src.getFiles().add((Object)file);
            }
        }
        if ((uri = (URI)this.getProperty(CoreProperties.INSTALLATION_PATH)) != null) {
            try {
                IPath p = this.getInstallationPath();
                if (p != null && !p.isEmpty()) {
                    uri = p.toFile().toURI();
                }
            }
            catch (Exception exception) {}
            try {
                MProject project = ProjectModelLoading.loadProjectModel((URI)uri);
                if (mainProject == null) {
                    mainProject = project;
                } else {
                    mainProject.mergeFrom(project, false);
                }
            }
            catch (Exception e) {
                throw Activator.reporter.newCoreException("project model " + String.valueOf(uri) + " is invalid", (Throwable)e);
            }
        }
        if (mainProject != null) {
            for (MModule module : mainProject.getModules()) {
                module.setBuiltin(true);
            }
            for (MConfiguration config : mainProject.getConfigurations()) {
                for (MModule module : config.getModules()) {
                    module.setBuiltin(true);
                }
            }
            String openedResouce = (String)mainProject.getProperties().get((Object)TemplateProperties.INITIALLY_OPENED_RESOURCE);
            if (((ITemplateDescriptor)this.getDescriptor()).getProperty(TemplateProperties.INITIALLY_OPENED_RESOURCE) == null) {
                this.setProperty(TemplateProperties.INITIALLY_OPENED_RESOURCE, openedResouce);
            }
        } else {
            mainProject = ProjectModelFactory.eINSTANCE.createMProject();
            Activator.reporter.logError("no content for project model in " + String.valueOf(this));
        }
        return mainProject;
    }

    private boolean isSlsprojModel() {
        if (super.getTemplateInstallPath() == null) {
            return true;
        }
        return IDEPreferenceManager.isSimplicityIDE((IIDE)IDEPreferenceManager.getPreferredIDE());
    }

    @Override
    public IProjectModel getProjectModel(ITemplateContext context) throws CoreException {
        IProjectModelTemplateContext projContext = (IProjectModelTemplateContext)context;
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = projContext.getProjectDescriptor().getBuildConfigurationDescriptors();
        int n = iBuildConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectTemplateSetupAdapter partAdapter;
            IBuildConfigurationDescriptor desc = iBuildConfigurationDescriptorArray[n2];
            ProjectModelUtils.findOrAddNewConfigurationFor(this.getMProject(), desc);
            ISDK sdk = (ISDK)SDK.manager().find(desc.getSdkId());
            IToolchain toolchain = (IToolchain)Toolchain.manager().find(desc.getToolchainId());
            IPart part = (IPart)Part.manager().find(desc.getPartId());
            IProjectTemplateSetupAdapter sdkAdapter = sdk != null ? (IProjectTemplateSetupAdapter)sdk.getAdapter(IProjectTemplateSetupAdapter.class) : null;
            IProjectTemplateSetupAdapter toolchainAdapter = toolchain != null ? (IProjectTemplateSetupAdapter)toolchain.getAdapter(IProjectTemplateSetupAdapter.class) : null;
            IProjectTemplateSetupAdapter iProjectTemplateSetupAdapter = partAdapter = part != null ? (IProjectTemplateSetupAdapter)part.getAdapter(IProjectTemplateSetupAdapter.class) : null;
            if (sdkAdapter != null) {
                sdkAdapter.setupProjectTemplate(projContext, desc, this);
            }
            if (toolchainAdapter != null) {
                toolchainAdapter.setupProjectTemplate(projContext, desc, this);
            }
            if (partAdapter != null) {
                partAdapter.setupProjectTemplate(projContext, desc, this);
            }
            String[] stringArray = desc.getBoardIds();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProjectTemplateSetupAdapter boardAdapter;
                String boardId = stringArray[n4];
                IBoard board = (IBoard)Board.manager().findCompatible(boardId);
                if (board != null && (boardAdapter = (IProjectTemplateSetupAdapter)board.getAdapter(IProjectTemplateSetupAdapter.class)) != null) {
                    boardAdapter.setupProjectTemplate(projContext, desc, this);
                }
                ++n4;
            }
            ++n2;
        }
        IProjectModel projectModel = IProjectModelEngineFactory.INSTANCE.createProjectModel(this.getMProject(), (IVariableLookup)new MapVariableLookup(context.getVariableMap()));
        return projectModel;
    }

    public void executeTemplateProcesses(ITemplateContext context, IProgressMonitor monitor) throws CoreException {
        boolean shouldExpand;
        super.executeTemplateProcesses(context, monitor);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        IProjectModelTemplateContext projContext = (IProjectModelTemplateContext)context;
        projContext.getObjectMap().put("templateContext", projContext);
        ProjectTemplateUtils.propagateTemplatePropertiesToVariableMap(this, projContext.getVariableMap());
        ProjectTemplateUtils.propagateTemplatePropertiesToObjectMap(this, projContext.getObjectMap());
        IProjectModel projectModel = this.getProjectModel(projContext);
        IProjectModelEngine engine = IProjectModelEngineFactory.INSTANCE.createProjectModelEngine(projectModel);
        IProjectEntity projEnt = projContext.getProjectEntity();
        projEnt.edit();
        projEnt.setup(projectModel, (IProgressMonitor)subMonitor.split(1));
        IProjectDescriptor projDesc = projContext.getProjectDescriptor();
        if (projDesc instanceof INewProjectDescriptor) {
            ((IWriteableDescriptor)projEnt).setProperty(ProjectProperties.IMPORT_MODE_ID, (Object)((INewProjectDescriptor)projDesc).getImportMode().getId());
        }
        IProjectEngineOperationFactory opFactory = ProjectEngineOperationUtils.getOperationFactory(projEnt);
        subMonitor.split(1);
        List<IProjectEngineOperation> operations = engine.createProjectEngineOperations(projDesc, opFactory);
        subMonitor.split(1);
        IProjectEngineOperationHandler operationHandler = projDesc.getProjectType().createProjectEngineOperationHandler(projEnt);
        boolean bl = shouldExpand = (Boolean)this.getProperty(TemplateProperties.COPY_ORIGINAL_CONTENT) == false;
        if (shouldExpand) {
            operationHandler = new TemplateProjectEngineOperationHandler(operationHandler, context, shouldExpand);
        }
        engine.applyProjectOperations(operations, operationHandler, (IProgressMonitor)subMonitor.split(3));
    }
}

