/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.type;

import com.silabs.java.utils.function.ThrowableRunnable;
import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.BuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectTypeData;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.platform.api.descriptor.core.BaseExtensionDescribable;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.manager.ManagerUtils;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyAccess;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class BaseProjectType
extends BaseExtensionDescribable
implements IProjectType {
    public BaseProjectType() {
    }

    public BaseProjectType(String id, String label, String description) {
        super(id, label, description);
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IProjectDescriptor projectDesc, IStockConfigurationDescriptor stock) {
        if (stock == null) {
            throw new IllegalArgumentException("null stock configuration");
        }
        if (stock.getParent() == null) {
            throw new IllegalArgumentException("invalid stock configuration: not assigned to toolchain");
        }
        IBuildConfigurationDescriptor desc = this.createBuildConfigurationDescriptor(projectDesc);
        desc.setName(stock.getId());
        desc.setLabel(MessageFormat.format("{0} - {1}", ((IToolchainDescriptor)stock.getParent()).getLabel(), stock.getLabel()));
        desc.setDescription(null);
        desc.setProperty(BuildConfigProperties.STOCK_CONFIG_ID, stock.getId());
        desc.setProperty(BuildConfigProperties.NEEDS_APPLY_STOCK, true);
        desc.setToolchainId(((IToolchainDescriptor)stock.getParent()).getId());
        return desc;
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IProjectDescriptor projectDesc, IBuildConfigurationDescriptor from) {
        IBuildConfigurationDescriptor desc = this.createBuildConfigurationDescriptor(projectDesc);
        desc.getPropertyAccess().copyFrom((IPropertyAccess)from.getPropertyAccess());
        desc.setName(from.getName());
        desc.setLabel(from.getLabel());
        desc.setDescription(from.getDescription());
        IDescriptor[] existing = projectDesc.getBuildConfigurationDescriptors();
        ManagerUtils.uniquifyDescriptorId((IWriteableDescriptor)desc, (IDescriptor[])existing);
        ManagerUtils.uniquifyDescriptorLabel((IWriteableDescriptor)desc, (IDescriptor[])existing);
        return desc;
    }

    @Override
    public IPath resolveFileLocation(IProjectDescriptor projDesc, IPath projectPath) {
        try {
            IPath installPath = projDesc.getInstallationPath();
            if (installPath != null && !Path.EMPTY.equals((Object)installPath)) {
                if (installPath.toFile().isFile() || installPath.getFileExtension() != null) {
                    installPath = installPath.removeLastSegments(1);
                }
                return installPath.append(projectPath);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public boolean projectFileExists(IProjectDescriptor projDesc, IPath projectPath) {
        IPath fileLoc = this.resolveFileLocation(projDesc, projectPath);
        return fileLoc == null ? false : fileLoc.toFile().exists();
    }

    @Override
    public String getPropertyScope() {
        return "project";
    }

    @Override
    public IBuildConfigurationDescriptor createBuildConfigurationDescriptor(IProjectDescriptor projectDesc) {
        return new BuildConfigurationDescriptor(projectDesc);
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor projDesc, File directory, String baseName) {
        return Collections.emptyList();
    }

    @Override
    public Collection<File> getSupportedSolutions(ISolutionDescriptor slnDesc, File directory, String baseName) {
        return Collections.emptyList();
    }

    @Override
    public <T extends Exception> void runProjectOperation(ThrowableRunnable<T> runnable) throws T {
        runnable.run();
    }

    @Override
    public Collection<String> matchingKeywords() {
        return Arrays.asList(this.getName());
    }

    @Override
    public boolean supportsMultipleConfigurations() {
        return false;
    }

    public <T> T getAdapter(Class<T> adapterClass) {
        if (ProjectTypeData.class.equals(adapterClass)) {
            return adapterClass.cast(ProjectTypeData.data().create());
        }
        return (T)super.getAdapter(adapterClass);
    }
}

