/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.compatibility.api.ICompatibility;
import com.silabs.ss.compatibility.api.ICompatibilityContext;
import com.silabs.ss.compatibility.api.ICompatibleExpression;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.hardware.HardwareContextBuilder;
import com.silabs.ss.platform.api.descriptor.core.hardware.IHardwareContext;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ProjectCompatUtils {
    private ProjectCompatUtils() {
    }

    public static IHardwareContext getHardwareContext(ISelectableDescriptor selectedDesc) {
        String partId = selectedDesc.getPartId();
        String[] boardIds = selectedDesc.getBoardIds();
        String sdkId = selectedDesc.getSdkId();
        String tcId = selectedDesc.getToolchainId();
        IHardwareContext context = HardwareContextBuilder.builder((IDescriptor[])new IDescriptor[0]).add((IRegistry)Part.manager(), new String[]{partId}).add((IRegistry)SDK.manager(), new String[]{sdkId}).add((IRegistry)Toolchain.manager(), new String[]{tcId}).add((IRegistry)Board.manager(), boardIds).createContext();
        return context;
    }

    public static boolean isCompatible(MSelectable selectable, IDescriptor ... descs) {
        IHardwareContext context = descs.length == 1 && descs[0] instanceof ISelectableDescriptor ? ProjectCompatUtils.getHardwareContext((ISelectableDescriptor)descs[0]) : IHardwareContext.create((IDescriptor[])descs);
        return ProjectCompatUtils.isCompatible(context, selectable);
    }

    public static boolean isCompatible(IHardwareContext context, MSelectable selectable) {
        Collection<ICompatibleExpression> compats = ProjectCompatUtils.getCompatibility(selectable);
        if (compats.isEmpty()) {
            return true;
        }
        boolean isCompatible = compats.parallelStream().allMatch(expr -> expr.isEmptyOrNull() || expr.isCompatible((ICompatibilityContext)context));
        return isCompatible;
    }

    public static void setCompatibility(MSelectable selectable, ICompatibleExpression ... exprs) {
        String compat = CoreTypes.COMPATIBILITY.stringize(Arrays.asList(exprs));
        selectable.setCompatibility(compat);
    }

    public static void setCompatibility(MSelectable selectable, Collection<ICompatibleExpression> exprs) {
        String compat = CoreTypes.COMPATIBILITY.stringize(exprs);
        selectable.setCompatibility(compat);
    }

    public static Collection<ICompatibleExpression> getCompatibility(MSelectable selectable) {
        Collection<ICompatibleExpression> compatibility = ProjectCompatUtils.getCompatProperty(selectable);
        if (!compatibility.isEmpty()) {
            return compatibility;
        }
        return ProjectCompatUtils.getLegacyComaptibility(selectable);
    }

    public static boolean hasCompatibility(MSelectable selectable) {
        boolean anyCompat = Stream.of(ProjectModelPackage.Literals.MSELECTABLE__COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__PART_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__BOARD_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__SDK_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__TOOLCHAIN_COMPATIBILITY).map(a -> ProjectCompatUtils.fetchProperty(selectable, a)).anyMatch(TextUtils::hasContent);
        if (anyCompat) {
            return true;
        }
        if (selectable instanceof MConfiguration) {
            return TextUtils.hasContent((String)ProjectCompatUtils.fetchProperty(selectable, ProjectModelPackage.Literals.MCONFIGURATION__STOCK_CONFIG_COMPATIBILITY));
        }
        return false;
    }

    private static Collection<ICompatibleExpression> getCompatProperty(MSelectable selectable) {
        String compatibility = ProjectCompatUtils.fetchProperty(selectable, ProjectModelPackage.Literals.MSELECTABLE__COMPATIBILITY);
        if (TextUtils.isEmpty((String)compatibility)) {
            return Collections.emptyList();
        }
        Object newValue = CoreTypes.COMPATIBILITY.convert(compatibility);
        if (newValue instanceof List) {
            return (List)newValue;
        }
        return Collections.emptyList();
    }

    private static Collection<ICompatibleExpression> getLegacyComaptibility(MSelectable selectable) {
        BiFunction<EAttribute, String, ICompatibleExpression> func = (attr, namespace) -> ICompatibility.INSTANCE.get(namespace, ProjectCompatUtils.fetchProperty(selectable, attr));
        ArrayList<ICompatibleExpression> compats = new ArrayList<ICompatibleExpression>();
        compats.add(func.apply(ProjectModelPackage.Literals.MSELECTABLE__PART_COMPATIBILITY, CoreProperties.PART_COMPATIBILITY.id()));
        compats.add(func.apply(ProjectModelPackage.Literals.MSELECTABLE__BOARD_COMPATIBILITY, CoreProperties.BOARD_COMPATIBILITY.id()));
        compats.add(func.apply(ProjectModelPackage.Literals.MSELECTABLE__SDK_COMPATIBILITY, SDKProperties.SDK_COMPATIBILITY.id()));
        compats.add(func.apply(ProjectModelPackage.Literals.MSELECTABLE__TOOLCHAIN_COMPATIBILITY, ToolchainProperties.TOOLCHAIN_COMPATIBILITY.id()));
        if (selectable instanceof MConfiguration) {
            compats.add(func.apply(ProjectModelPackage.Literals.MCONFIGURATION__STOCK_CONFIG_COMPATIBILITY, StockConfigurationProperties.STOCK_CONFIG_COMPATIBILITY.id()));
        }
        return compats;
    }

    private static String fetchProperty(MSelectable selector, EAttribute attr) {
        if (!(selector instanceof MEntry)) {
            String val = (String)selector.eGet((EStructuralFeature)attr);
            return val;
        }
        if (selector instanceof MProject) {
            return null;
        }
        MEntry ent = (MEntry)selector;
        while (ent != null) {
            String val = (String)ent.eGet((EStructuralFeature)attr);
            if (val != null) {
                return val;
            }
            if ((ent = (MEntry)ent.eContainer()) instanceof MProject) break;
        }
        return null;
    }
}

