/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.SystemSettings;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.launcher.core.InstallHelperSetupTask;
import com.silabs.ss.platform.api.rcp.core.DevUtils;
import com.silabs.ss.platform.api.rcp.core.process.IProgramPathUtils;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class ProjectUtils {
    private static boolean showMakeError = true;
    public static final String SLS_CPP_PROJECT_TYPE_ID = "com.silabs.ss.framework.ide.project.core.cdtMbsProjectType";
    public static final String CDT_MBS_SLS_PROJECT_TYPE_ID = "com.silabs.ss.framework.ide.project.core.cdt.cdtMbsProjectType";
    private static String SLS_PROJECT_TYPE = "com.silabs.ss.framework.ide.project.core.slsExternalProjectType";
    private static String SLSPROJ_EXTERNAL_PROJECT_TYPE = "com.silabs.ss.framework.ide.project.core.slsProjExternalProjectType";
    private static String SLS_ARCHIVE_PROJECT_TYPE = "com.silabs.ss.framework.ide.project.core.SlsArchiveExternalProjectType";

    private ProjectUtils() {
    }

    public static IExternalType getSlsExistingProjectType() {
        IExternalType extType = ProjectType.manager().findExternalType(SLS_PROJECT_TYPE);
        if (extType == null) {
            throw new IllegalStateException("no existing external project type registered: " + SLS_PROJECT_TYPE);
        }
        return extType;
    }

    public static IExternalType getSlsProjProjectType() {
        IExternalType extType = ProjectType.manager().findExternalType(SLSPROJ_EXTERNAL_PROJECT_TYPE);
        if (extType == null) {
            throw new IllegalStateException("no existing external project type registered: " + SLSPROJ_EXTERNAL_PROJECT_TYPE);
        }
        return extType;
    }

    public static IProjectType getCDTMbsProjectType() {
        IProjectType extType = ProjectType.manager().findProjectType(SLS_CPP_PROJECT_TYPE_ID);
        if (extType == null) {
            throw new IllegalStateException("no existing external project type registered: com.silabs.ss.framework.ide.project.core.cdtMbsProjectType");
        }
        return extType;
    }

    public static boolean isSlsArchiveProjectType(IExternalType extType) {
        if (extType == null) {
            return false;
        }
        return extType.getId().equals(SLS_ARCHIVE_PROJECT_TYPE);
    }

    public static String getMakefileIdeCompatibilityId() {
        return "makefile-ide";
    }

    public static String getGenericTemplateCompatibilityId() {
        return "generic-template";
    }

    public static IPath getMakeDir() {
        try {
            if (!TextUtils.isEmpty((String)SystemSettings.MAKE_LOCATION.value())) {
                Path path = new Path(SystemSettings.MAKE_LOCATION.value());
                if (path.toFile().exists()) {
                    return path;
                }
                Activator.reporter.logWarning("Overridden make path does not exist for " + SystemSettings.MAKE_LOCATION.value());
            }
            if (HostUtils.isWindows()) {
                if (RuntimeUtils.isPlatformPDELaunch()) {
                    IPath pluginPath = DevUtils.getPluginSourceDirectory((Bundle)Activator.getContext().getBundle());
                    IPath msysPath = pluginPath.removeLastSegments(3).append("framework_ide/features/com.silabs.ss.framework.ide.feature/build-support/win32/x86_64/msys/1.0/bin");
                    if (msysPath.toFile().exists()) {
                        return msysPath;
                    }
                    msysPath = new Path("C:\\MinGW\\msys\\1.0\\bin");
                    if (msysPath.toFile().exists()) {
                        return msysPath;
                    }
                    Activator.reporter.logWarning("no msys found in installation or PATH");
                } else {
                    IPath msysPath = DevUtils.getInstallPath().append("support/common/build/msys/1.0/bin");
                    if (msysPath.toFile().exists()) {
                        return msysPath;
                    }
                    if (RuntimeUtils.isJUnitRunning() && (msysPath = DevUtils.getWorkspaceLocation().append("support/common/build/msys/1.0/bin")).toFile().exists()) {
                        return msysPath;
                    }
                }
            } else if (HostUtils.isOSX()) {
                IPath buildSupportPath = null;
                if (RuntimeUtils.isPlatformPDELaunch()) {
                    IPath pluginPath = DevUtils.getPluginSourceDirectory((Bundle)Activator.getContext().getBundle());
                    buildSupportPath = pluginPath.removeLastSegments(3).append("framework_ide/features/com.silabs.ss.framework.ide.feature/build-support/macosx/x86_64");
                } else {
                    buildSupportPath = RuntimeUtils.isJUnitRunning() ? DevUtils.getWorkspaceLocation().append("support/common/build") : DevUtils.getInstallPath().append("support/common/build");
                }
                if (buildSupportPath.toFile().exists()) {
                    return buildSupportPath;
                }
                if (showMakeError) {
                    showMakeError = false;
                    Activator.reporter.logError("Unable to locate make in " + buildSupportPath.toOSString());
                }
            } else {
                String makeLocation = InstallHelperSetupTask.findTool((String)"make");
                if (makeLocation != null) {
                    return new Path(makeLocation).removeLastSegments(1);
                }
                if (showMakeError) {
                    showMakeError = false;
                    Activator.reporter.logError("Unable to locate make");
                }
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return null;
    }

    public static String getMakePath() {
        IPath makeExeDir = ProjectUtils.getMakeDir();
        if (makeExeDir != null && TextUtils.hasContent((String)makeExeDir.toOSString())) {
            return makeExeDir.append(IProgramPathUtils.INSTANCE.canonicalizeExecutableName("make")).toOSString();
        }
        return null;
    }

    public static List<String> generatorExcludedPaths(IProjectEntity entity) {
        if (entity == null) {
            return List.of();
        }
        String projTypeId = Optional.ofNullable(entity.getProjectType()).map(IDescribable::getId).orElse("");
        if ("cmake".equals(projTypeId)) {
            return List.of();
        }
        return List.of(entity.getName() + "_cmake", entity.getName() + "_iar_cmake");
    }
}

