/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import com.silabs.java.utils.Pair;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.ImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.IBaseWriteableSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.ISolutionModel;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModule;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReferenceContainer;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionSettings;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.model.util.manual.SolutionModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.solution.SolutionModel;
import com.silabs.ss.framework.project.internal.core.solution.engine.SolutionModelEngine;
import com.silabs.ss.framework.project.internal.core.solution.engine.SolutionModelMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MBuiltin;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptorProperties;
import com.silabs.ss.platform.api.descriptor.core.model.impl.StringToStringMapImpl;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class SolutionUpdateUtils {
    private SolutionUpdateUtils() {
    }

    public static Optional<Pair<ISolutionEntity, File>> loadSolutionEntity(IProjectType slnType, ISolutionDescriptor slnDesc, File genDir) {
        Collection<File> supportedFiles = slnType.getSupportedSolutions(slnDesc, genDir, slnDesc.getName());
        if (supportedFiles.isEmpty()) {
            return Optional.empty();
        }
        File singleFile = supportedFiles.iterator().next();
        ISolutionEntity slnEnt = slnType.createSolutionEntity(slnDesc.copy(), singleFile);
        ((IWriteableDescriptor)slnEnt).setProperty(CoreProperties.INSTALLATION_PATH, (Object)singleFile.toURI());
        return Optional.of(Pair.of((Object)slnEnt, (Object)singleFile));
    }

    public static ISolutionModel importUserSolution(ISolutionEntity entity, IProgressMonitor monitor) throws CoreException {
        ISolutionModel rawSolution = SolutionUpdateUtils.importRawSolution(entity, monitor, true);
        return SolutionUpdateUtils.formatUserModel(entity, rawSolution);
    }

    public static ISolutionModel importRawSolution(ISolutionEntity entity, IProgressMonitor monitor, boolean simplify) throws CoreException {
        ImportSolutionDescriptor importDescr = new ImportSolutionDescriptor(entity.getName());
        importDescr.setInputLocation(entity.getSolutionPath().toFile());
        importDescr.setImportMode(ImportMode.IN_PLACE);
        IExternalImporter extType = Optional.ofNullable(entity.getSolutionType()).map(IProjectType::getExternalType).map(IExternalType::getImportType).orElseThrow(() -> Activator.reporter.newCoreException("No external type found to import with!"));
        MSolution solutionModel = extType.createImportSolutionModel(importDescr, monitor);
        if (solutionModel == null) {
            solutionModel = SolutionModelFactory.eINSTANCE.createMSolution();
        }
        solutionModel.getConfigs().forEach(c -> {
            if (!c.isBuiltin()) {
                return;
            }
            boolean hasUserConent = c.eContents().stream().map(arg_0 -> ((Caster)Caster.with(MBuiltin.class)).cast(arg_0)).filter(Objects::nonNull).anyMatch(b -> !b.isBuiltin());
            c.setBuiltin(!hasUserConent);
        });
        if (simplify) {
            SolutionModelMergeUtils.mergeCommonSettings(solutionModel);
        }
        return new SolutionModel(solutionModel, null, (URI)entity.getProperty(CoreProperties.INSTALLATION_PATH));
    }

    private static ISolutionModel formatUserModel(ISolutionEntity entity, ISolutionModel rawModel) {
        MSolution userModel = (MSolution)EcoreTypeUtils.copy((EObject)rawModel.getModel());
        SolutionModelSwitchRecurser<Object> cleaner = new SolutionModelSwitchRecurser<Object>(){

            public Object caseMSolutionSettings(MSolutionSettings settings) {
                if (settings.hasPostBuildStep() && settings.getPostbuildStep().isBuiltin()) {
                    settings.setPostbuildStep(null);
                }
                if (settings.hasPreBuildStep() && settings.getPrebuildStep().isBuiltin()) {
                    settings.setPrebuildStep(null);
                }
                settings.getProjects().removeIf(MBuiltin::isBuiltin);
                return null;
            }

            public Object caseMDescriptorProperties(MDescriptorProperties desc) {
                desc.getPropertySet().removeIf(StringToStringMapImpl::isBuiltin);
                return null;
            }

            protected boolean recurseSdms() {
                return false;
            }
        };
        cleaner.doSwitch((EObject)userModel);
        userModel.getConfigs().removeIf(c -> c.eContents().isEmpty() && c.isBuiltin());
        return new SolutionModel(userModel, rawModel, rawModel.getContentRootURI());
    }

    public static void updateToolContribution(ISolutionModel slnModel, MSolutionModuleReferenceContainer settings, String contributionId, MSolutionModule toolSettings) {
        SolutionUpdateUtils.updateToolContribution(slnModel.getModel(), settings, contributionId, toolSettings);
    }

    public static void updateToolContribution(MSolution solution, MSolutionModuleReferenceContainer settings, String contributionId, MSolutionModule toolSettings) {
        toolSettings.setId(contributionId);
        solution.getSolutionDefinedModules().removeIf(p -> Objects.equals(p.getId(), toolSettings.getId()));
        solution.getSolutionDefinedModules().add((Object)toolSettings);
        MSolutionModuleReference ref = SolutionModelFactory.eINSTANCE.createMSolutionModuleReference();
        ref.setId(contributionId);
        EList modeRefs = settings.getSolutionModuleReferences();
        if (modeRefs.stream().noneMatch(p -> Objects.equals(p.getId(), ref.getId()))) {
            modeRefs.add(ref);
        }
    }

    public static void updateSolutionFromModel(ISolutionModel model, ISolutionEntity solution, IProgressMonitor monitor) throws CoreException {
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        ISolutionEngineOperationHandler operationHandler = solution.getSolutionType().createSolutionEngineOperationHandler(solution);
        if (operationHandler.getSolutionEntity() != null && operationHandler.getSolutionEntity() != solution) {
            throw new IllegalArgumentException("Solution entities are not the same!");
        }
        SolutionModel model_copy = new SolutionModel(model.getModel().copy(), model.getRawModel(), model.getContentRootURI());
        IProjectType slnType = null;
        if (!Objects.equals(solution.getSolutionType(), ((ISolutionDescriptor)solution.getDescriptor()).getSolutionType())) {
            slnType = ((ISolutionDescriptor)solution.getDescriptor()).getSolutionType();
            ((IBaseWriteableSolutionDescriptor)solution.getDescriptor()).setSolutionType(solution.getSolutionType());
        }
        submon.split(1);
        operationHandler.load();
        SolutionModelEngine engine = SolutionModelEngine.create(solution, model_copy, operationHandler);
        IStatus status = engine.runSolutionUpdate((IProgressMonitor)submon.split(3));
        submon.split(1);
        operationHandler.commit();
        if (slnType != null) {
            ((IBaseWriteableSolutionDescriptor)solution.getDescriptor()).setSolutionType(slnType);
        }
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
    }
}

