/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.engine.hash;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.engine.hash.FileContentHashing;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class GuavaFileContentHasher
implements FileContentHashing.FileContentHasher {
    public static FileContentHashing.FileContentHasher INSTANCE = new GuavaFileContentHasher();

    @Override
    public int calculateContent(File contentFile) {
        if (!contentFile.isFile()) {
            return 0;
        }
        try {
            return Files.asByteSource((File)contentFile).hash(this.hashFunc()).asInt();
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return 0;
        }
    }

    @Override
    public int calculateContent(String contents) {
        if (TextUtils.isEmpty((String)contents)) {
            return 0;
        }
        return this.hashFunc().hashString((CharSequence)contents, Charset.defaultCharset()).asInt();
    }

    private HashFunction hashFunc() {
        return Hashing.crc32();
    }
}

