/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IFlagParser;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.ConvertedOptionsUtils;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.internal.api.core.external.impl.HiTechFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.RaisonanceFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.SDCCFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.TaskingFlagParser;
import com.silabs.ss.framework.project.internal.api.core.external.impl.WSPFileReader;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARFlagParser;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;

public class LegacyIDEExternalProjectImporter
extends BaseExternalProjectImporter
implements IExternalImporter {
    public LegacyIDEExternalProjectImporter(String superTypeId) {
        super(superTypeId);
    }

    @Override
    public ImportProjectRecord[] findProjects(File projectLocation) {
        File[] files = projectLocation.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".wsp"));
        ArrayList<ImportProjectRecord> projectRecordsList = new ArrayList<ImportProjectRecord>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                projectRecordsList.add(new ImportProjectRecord(this.removeExtensionFromFilename(file.getName()), file));
                ++n2;
            }
        }
        return (ImportProjectRecord[])projectRecordsList.toArray(ImportProjectRecord[]::new);
    }

    protected String removeExtensionFromFilename(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    @Override
    public MProject createImportModel(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        WSPFileReader wspReader;
        File projectFile = importDescr.getInputLocation();
        if (!projectFile.isFile()) {
            throw Activator.reporter.newCoreException("File not found for " + String.valueOf(projectFile));
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream in = new FileInputStream(projectFile);){
                wspReader = new WSPFileReader(projectFile);
                wspReader.parse();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Could not parse file", (Throwable)e);
        }
        LegacyIDEProjectImporter importer = new LegacyIDEProjectImporter(importDescr);
        MProject mproject = importer.importProject(wspReader);
        return mproject;
    }

    static class LegacyIDEProjectImporter {
        private final IImportProjectDescriptor importDescr;
        private final MProject project;
        private final IProjectModel model;
        private final File contentRoot;
        private URI relativeIncludeRoot;
        private final MConfiguration config;
        private Set<String> excludedPaths;
        private Set<String> unconvertedVariables;

        public LegacyIDEProjectImporter(IImportProjectDescriptor importDescr) {
            this.importDescr = importDescr;
            this.project = ProjectModelFactory.eINSTANCE.createMProject();
            this.project.setName(importDescr.getName());
            this.project.setPartCompatibility("mcu.8051.*");
            this.contentRoot = importDescr.getImportProjectRecord().getProjectDirectory();
            this.project.setContentRoot(this.contentRoot.toURI().toString());
            this.model = IProjectModelEngineFactory.INSTANCE.createProjectModel(this.project, null);
            this.config = ProjectModelFactory.eINSTANCE.createMConfiguration();
            this.config.setName("Default");
            this.excludedPaths = new LinkedHashSet<String>();
            this.unconvertedVariables = new HashSet<String>();
            this.relativeIncludeRoot = null;
        }

        private MProject importProject(WSPFileReader reader) {
            String path;
            List<String> folders = reader.getData("Folders.FolderName.*");
            Set<String> projectFiles = this.getProjectSourceFiles(reader);
            Set<String> linkerFiles = this.getLinkerFiles(reader, projectFiles);
            ArrayList<MBuildSetting> libraryPaths = new ArrayList<MBuildSetting>();
            HashSet<String> projectPFiles = new HashSet<String>(reader.getData("PFiles.FileName.*"));
            HashSet<String> projectCFiles = new HashSet<String>(reader.getData("CFiles.FileName.*"));
            HashSet<String> projectAFiles = new HashSet<String>(reader.getData("AFiles.FileName.*"));
            HashSet<String> projectLFiles = new HashSet<String>(reader.getData("LFiles.FileName.*"));
            for (String groupName : folders) {
                MFolderEntry folder = ProjectModelUtils.findOrCreateFolder(this.model, (MFolderEntry)this.project, groupName);
                List<String> files = reader.getData(MessageFormat.format("{0}.{1}.*", groupName, "FileName"));
                for (String fileName : files) {
                    this.findIncludeBasePath(fileName);
                    String path2 = this.addFile(folder.getName(), folder, fileName);
                    if (projectFiles.contains(fileName)) {
                        projectFiles.remove(fileName);
                    }
                    this.addExcludedPathIfNotIncluded(fileName, path2, projectPFiles, projectCFiles, projectAFiles, projectLFiles);
                    this.addImportedLinkerBuildSettingToList(linkerFiles, libraryPaths, groupName, fileName);
                }
            }
            for (String fileName : projectFiles) {
                path = this.addFile(".", (MFolderEntry)this.project, fileName);
                boolean wasAdded = this.addImportedLinkerBuildSettingToList(linkerFiles, libraryPaths, ".", fileName);
                if (wasAdded) continue;
                this.addExcludedPathIfNotIncluded(fileName, path, projectPFiles, projectCFiles, projectAFiles, projectLFiles);
            }
            for (String fileName : linkerFiles) {
                path = this.addFile("", (MFolderEntry)this.project, fileName);
                MLibraryFile lib = ProjectImportUtils.createMLibraryFileFromString(path, this.model.getContentRootURI());
                libraryPaths.add((MBuildSetting)lib);
            }
            ProjectImportUtils.addBuildSettingsToSettingsSite((MSettingsSite)this.config, libraryPaths);
            this.config.getExcludedPaths().addAll(this.excludedPaths);
            this.project.getConfigurations().add((Object)this.config);
            if (reader.getData("Vendor").size() == 0) {
                this.importDescr.getReport().addMessage(2, "Unrecognized toolchain vendor. Build settings have not been imported: please verify these manually.");
                return this.project;
            }
            String vendorString = reader.getData("Vendor").get(0);
            int vendor = Integer.parseInt(vendorString);
            HashMap<ImporterTool.ToolType, List<String>> toolFlags = new HashMap<ImporterTool.ToolType, List<String>>();
            toolFlags.put(ImporterTool.ToolType.ASSEMBLER, reader.getData("AssFlag.*"));
            toolFlags.put(ImporterTool.ToolType.COMPILER, reader.getData("CompFlag.*"));
            toolFlags.put(ImporterTool.ToolType.LINKER, this.joinStringsInList(reader.getData("LinkFlag.*"), ", "));
            HashMap<IProperty, Object> flagProperties = new HashMap<IProperty, Object>();
            IFlagParser flagParser = this.getVendorProperties(vendor);
            this.addOptionMappingRegistry(flagParser.getGenericRegistry());
            this.addOptionMappingRegistry(flagParser.getDirectRegistry());
            ArrayList<MBuildSetting> buildSettings = new ArrayList<MBuildSetting>();
            this.getBuildSettingsFromFlagList(flagParser, toolFlags, buildSettings, flagProperties);
            ProjectImportUtils.addBuildSettingsToSettingsSite((MSettingsSite)this.config, buildSettings);
            if (flagParser.getToolchainCompatibility().equals("-.*")) {
                this.importDescr.getReport().addMessage(2, "Custom command line flags have not been imported; please verify these manually.");
            } else {
                if (!flagParser.getToolchainCompatibility().equals(".*keil.*")) {
                    this.importDescr.getReport().addMessage(2, "Custom command line flags may not have not been fully imported; please verify these manually.");
                }
                for (IProperty property : flagProperties.keySet()) {
                    ConvertedOptionsUtils.findOrCreateSpecificOption((MSettingsSite)this.config, (IProperty)property, flagProperties.get(property));
                }
            }
            this.project.setToolchainCompatibility(flagParser.getToolchainCompatibility());
            Collection<String> unconvertedFlagParserVariables = flagParser.getUnconvertedVariables();
            if (unconvertedFlagParserVariables != null) {
                this.unconvertedVariables.addAll(unconvertedFlagParserVariables);
            }
            if (!this.unconvertedVariables.isEmpty()) {
                this.importDescr.getReport().addMessage(2, "The following variables were detected but are are not currently supported: " + TextUtils.catenateStrings(this.unconvertedVariables, (String)", "));
            }
            return this.project;
        }

        private List<String> joinStringsInList(List<String> list, String sep) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                if (i != 0) {
                    sb.append(sep);
                }
                sb.append(list.get(i));
                ++i;
            }
            ArrayList<String> newList = new ArrayList<String>();
            newList.add(sb.toString());
            return newList;
        }

        private void findIncludeBasePath(String fileName) {
            if (this.relativeIncludeRoot == null) {
                try {
                    Path path = new Path(fileName);
                    Object parentPath = path.removeLastSegments(1).toString();
                    if (!((String)parentPath).endsWith("/")) {
                        parentPath = (String)parentPath + "/";
                    }
                    URI fileURI = URIUtil.fromString((String)parentPath);
                    this.relativeIncludeRoot = URIUtils.resolveURIFrom((URI)this.contentRoot.toURI(), (URI)fileURI);
                }
                catch (IOException | URISyntaxException exception) {}
            }
        }

        private void addExcludedPathIfNotIncluded(String fileName, String path, Set<String> pfiles, Set<String> cfiles, Set<String> afiles, Set<String> lfiles) {
            if ((!pfiles.isEmpty() && pfiles.contains(fileName) || pfiles.isEmpty()) && !cfiles.contains(fileName) && !afiles.contains(fileName) && !lfiles.contains(fileName)) {
                this.excludedPaths.add("./" + path);
            }
        }

        private void addOptionMappingRegistry(IGenericOptionMappingRegistry reg) {
            if (reg != null) {
                this.importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)reg);
            }
        }

        private void addOptionMappingRegistry(IDirectOptionMappingRegistry reg) {
            if (reg != null) {
                this.importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)reg);
            }
        }

        private IFlagParser getVendorProperties(int vendor) {
            switch (vendor) {
                case 0: {
                    return new KeilFlagParser();
                }
                case 1: {
                    return new RaisonanceFlagParser();
                }
                case 2: {
                    return new TaskingFlagParser();
                }
                case 4: {
                    return new HiTechFlagParser();
                }
                case 5: {
                    return new SDCCFlagParser();
                }
                case 6: {
                    return new IARFlagParser(ImporterTool.ToolchainID.EIGHTYFIFTYONE);
                }
            }
            throw new IllegalArgumentException("Unknown vendor for code: " + vendor);
        }

        private void getBuildSettingsFromFlagList(IFlagParser flagParser, Map<ImporterTool.ToolType, List<String>> toolFlags, List<MBuildSetting> buildSettings, Map<IProperty, Object> flagProperties) {
            for (ImporterTool.ToolType tool : toolFlags.keySet()) {
                Map<IProperty, Object> foundProperties;
                List<String> flags;
                List<String> wspFlagList = toolFlags.get((Object)tool);
                if (wspFlagList.isEmpty() || (flags = flagParser.splitCommandLineFlags(wspFlagList.get(0))) == null || flags.isEmpty()) continue;
                List<MBuildSetting> foundBuildSettings = flagParser.getBuildSettingsFromFlagList(flags, ImporterTool.ToolchainID.EIGHTYFIFTYONE, tool, this.relativeIncludeRoot == null ? this.contentRoot.toURI() : this.relativeIncludeRoot, this.importDescr, null);
                if (foundBuildSettings != null) {
                    buildSettings.addAll(foundBuildSettings);
                }
                if ((foundProperties = flagParser.getFlagProperties(flags, ImporterTool.ToolchainID.EIGHTYFIFTYONE, tool)) == null) continue;
                flagProperties.putAll(foundProperties);
            }
        }

        private boolean addImportedLinkerBuildSettingToList(Set<String> linkerFiles, List<MBuildSetting> libraryPaths, String groupName, String fileName) {
            if (linkerFiles.contains(fileName)) {
                linkerFiles.remove(fileName);
                MLibraryFile lib = ProjectImportUtils.createMLibraryFileFromString(groupName.concat("\\").concat(fileName), this.model.getContentRootURI());
                libraryPaths.add((MBuildSetting)lib);
                return true;
            }
            return false;
        }

        private Set<String> getProjectSourceFiles(WSPFileReader reader) {
            HashSet<String> projectFiles = new HashSet<String>(reader.getData("PFiles.FileName.*"));
            projectFiles.addAll(reader.getData("AFiles.FileName.*"));
            projectFiles.addAll(reader.getData("CFiles.FileName.*"));
            for (String filename : projectFiles) {
                String ext = FileUtils.getExtension((String)filename);
                if (ext == null || !(ext = ext.toLowerCase(Locale.ROOT)).matches("\\#[0-9]*") && !ext.equals("obj")) continue;
                projectFiles.remove(filename);
            }
            return projectFiles;
        }

        private Set<String> getLinkerFiles(WSPFileReader reader, Set<String> projectFiles) {
            Set<String> projectFilesNoExtension = this.removeExtensions(projectFiles);
            HashSet<String> linkerFiles = new HashSet<String>(reader.getData("LFiles.FileName.*"));
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String file : linkerFiles) {
                if (!projectFilesNoExtension.contains(FileUtils.stripExtension((String)file))) continue;
                toRemove.add(file);
            }
            ProjectImportUtils.removeStringsFromStringList(linkerFiles, toRemove);
            linkerFiles = new HashSet<String>(linkerFiles);
            return linkerFiles;
        }

        private Set<String> removeExtensions(Collection<String> strings) {
            HashSet<String> noExtensions = new HashSet<String>();
            for (String string : strings) {
                noExtensions.add(FileUtils.stripExtension((String)string));
            }
            return noExtensions;
        }

        private String addFile(String parentPath, MFolderEntry folder, String fileName) {
            String basePath = fileName.replace('\\', '/');
            File realFile = new File(this.contentRoot, basePath);
            MFileContent file = ProjectModelUtils.findOrCreateFileContent(this.model, folder, realFile.getName(), realFile.getPath());
            if (this.importDescr.getImportMode() == ImportMode.LINK || folder instanceof MFolderContent && ((MFolderContent)folder).isVirtual()) {
                file.setLinked(Boolean.valueOf(true));
            }
            return (String)(parentPath.isEmpty() ? "" : parentPath + "/") + realFile.getName();
        }
    }
}

