/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.ss.framework.project.api.core.external.IFlagParser;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IStringSplitter;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingRegistryFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SDCCFlagParser
implements IFlagParser {
    private static final Pattern COMPILER_INCLUDE = Pattern.compile("(?<=^-I).*");
    private static final Pattern COMPILER_MACRO = Pattern.compile("(?<=^-D).*");
    private static final Pattern ASSEMBLER_INCLUDE = Pattern.compile("(?<=^-I).*");
    private static final Pattern ASSEMBLER_MACRO = Pattern.compile("(?<=^(-D|--def-sym)).*");
    private static final Pattern LINKER_LIBPATH = Pattern.compile("(?<=^(-L|--lib-path|-l)).*");
    public static final IGenericOptionMappingRegistry genericRegistry = null;
    public static final IDirectOptionMappingRegistry directRegistry = OptionMappingRegistryFactory.INSTANCE.createDirectOptionMappingRegistry();
    public static final IPropertyGroup variousOptionsGroup = Property.registry().registerPropertyGroup(Activator.id() + ".sdcc.various", "SDCC Various", "Various Options");
    public static final IProperty COMPILER_MISC = Property.registry().registerProperty(variousOptionsGroup, "CompilerMiscFlags", "string", "Compiler Misc. Flags");
    public static final IProperty ASSEMBLER_MISC = Property.registry().registerProperty(variousOptionsGroup, "AssemblerMiscFlags", "string", "Assembler Misc. Flags");
    public static final IProperty LINKER_MISC = Property.registry().registerProperty(variousOptionsGroup, "LinkerMiscFlags", "string", "Linker Misc. Flags");
    private static Map<ImporterTool.ToolType, IProperty> miscProperties = new HashMap<ImporterTool.ToolType, IProperty>();

    public SDCCFlagParser() {
        ProjectImportUtils.unmap(COMPILER_MISC, directRegistry);
        ProjectImportUtils.unmap(LINKER_MISC, directRegistry);
        ProjectImportUtils.unmap(ASSEMBLER_MISC, directRegistry);
        miscProperties.put(ImporterTool.ToolType.COMPILER, COMPILER_MISC);
        miscProperties.put(ImporterTool.ToolType.ASSEMBLER, ASSEMBLER_MISC);
        miscProperties.put(ImporterTool.ToolType.LINKER, LINKER_MISC);
    }

    @Override
    public String getToolchainCompatibility() {
        return "-.*";
    }

    @Override
    public Map<IProperty, Object> getFlagProperties(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType) {
        IProperty miscProperty = miscProperties.get((Object)toolType);
        if (miscProperty == null) {
            return null;
        }
        String value = ProjectImportUtils.squashStringListToString(flags);
        HashMap<IProperty, Object> flagProperties = new HashMap<IProperty, Object>();
        flagProperties.put(miscProperty, value);
        return flagProperties;
    }

    @Override
    public IGenericOptionMappingRegistry getGenericRegistry() {
        return genericRegistry;
    }

    @Override
    public IDirectOptionMappingRegistry getDirectRegistry() {
        return directRegistry;
    }

    @Override
    public List<MBuildSetting> getBuildSettingsFromFlagList(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType, URI basePath, IImportProjectDescriptor desc, Map<String, String> variables) {
        Pattern includePattern = null;
        Pattern macroPattern = null;
        Pattern libPattern = null;
        IStringSplitter includeSplitter = ProjectImportUtils.getSemicolonOrCommaStringSplitter();
        IStringSplitter macroSplitter = ProjectImportUtils.getMacroSemicolonOrCommaStringSplitter();
        if (toolType == ImporterTool.ToolType.COMPILER) {
            includePattern = COMPILER_INCLUDE;
            macroPattern = COMPILER_MACRO;
        } else if (toolType == ImporterTool.ToolType.ASSEMBLER) {
            includePattern = ASSEMBLER_INCLUDE;
            macroPattern = ASSEMBLER_MACRO;
        } else if (toolType == ImporterTool.ToolType.LINKER) {
            libPattern = LINKER_LIBPATH;
        }
        return ProjectImportUtils.createBuildSettingsFromFlags(flags, basePath, ProjectImportUtils.getELanguage(toolType), includePattern, includeSplitter, macroPattern, macroSplitter, libPattern, includeSplitter, null, null, desc, variables, null, this.getUnconvertedVariables());
    }

    @Override
    public List<String> splitCommandLineFlags(String flags) {
        return ProjectImportUtils.splitHyphenDeliminatedFlags(flags);
    }

    @Override
    public Collection<String> getUnconvertedVariables() {
        return null;
    }
}

