/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.java.utils.runtime.RuntimeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WSPFileReader {
    public static final String KEY_VENDOR = "Vendor";
    public static final String KEY_ASSEMBLER = "Assembler";
    public static final String KEY_ASS_FLAG = "AssFlag.*";
    public static final String KEY_ASS_FORMAT = "AssFormat";
    public static final String KEY_COMPILER = "Compiler";
    public static final String KEY_COMP_FLAG = "CompFlag.*";
    public static final String KEY_COMP_FORMAT = "CompFormat";
    public static final String KEY_LINKER = "Linker";
    public static final String KEY_LINK_FLAG = "LinkFlag.*";
    public static final String KEY_LINK_FORMAT = "LinkFormat";
    public static final String KEY_OUTPUT_FILE = "OutputFile";
    public static final String KEY_MAKE_FILE = "MakeFile";
    public static final String KEY_HEX_GENERATOR = "HexGenerator";
    public static final String KEY_GEN_HEX = "GenHex";
    public static final String KEY_USB_ADAPTER_POWER = "USB Adapter Power";
    public static final String KEY_ADAPTER_SN = "AdapterSN";
    public static final String KEY_ADAPTER = "Adapter";
    public static final String KEY_C2_STROBE_TIME = "C2StrobeTime";
    public static final String KEY_EC_PROTOCOL = "ECProtocol";
    public static final String KEY_C_EXT = "CExt";
    public static final String CAT_MULTI_DEVICE_JTAG = "MultiDeviceJTAG";
    public static final String KEY_JTAG_DEVICES_AFTER_TARGET = "DevicesAfterTarget";
    public static final String KEY_JTAG_DEVICES_BEFORE_TARGET = "DevicesBeforeTarget";
    public static final String KEY_JTAG_BITS_AFTER_TARGET_IR = "BitsAfterTargetIR";
    public static final String KEY_JTAG_BITS_BEFORE_TARGET_IR = "BitsBeforeTargetIR";
    public static final String CAT_HEADER_FILES = "Header Files.FileName.*";
    public static final String CAT_SOURCE_FILES = "Source Files.FileName.*";
    public static final String CAT_FOLDERS = "Folders.FolderName.*";
    public static final String CAT_BANK_MAP = "BankMap.FileName.*";
    public static final String CAT_L_FILES = "LFiles.FileName.*";
    public static final String CAT_C_FILES = "CFiles.FileName.*";
    public static final String CAT_A_FILES = "AFiles.FileName.*";
    public static final String CAT_P_FILES = "PFiles.FileName.*";
    public static final String KEY_FILE_NAME = "FileName";
    public static final String KEY_FOLDER_NAME = "FolderName";
    public static final String KEY_BANK_NUM = "BankNum";
    private static final Pattern categoryPattern = Pattern.compile("\\[WorkState_v1_1\\.(.+)\\]");
    private static final Pattern mappingPattern = Pattern.compile("(.+?)=(.+)");
    private static Map<String, List<String>> categoryToKeys = new LinkedHashMap<String, List<String>>();
    private static Map<String, String> dynamicCategories;
    private File file;
    private Map<String, List<String>> dynamicCategoryToKeys;
    private Map<String, Map<String, List<String>>> results;

    static {
        categoryToKeys.put(KEY_VENDOR, new ArrayList<String>(Arrays.asList(KEY_VENDOR)));
        categoryToKeys.put(KEY_ASSEMBLER, new ArrayList<String>(Arrays.asList(KEY_ASSEMBLER)));
        categoryToKeys.put(KEY_ASS_FLAG, new ArrayList<String>(Arrays.asList(KEY_ASS_FLAG)));
        categoryToKeys.put(KEY_ASS_FORMAT, new ArrayList<String>(Arrays.asList(KEY_ASS_FORMAT)));
        categoryToKeys.put(KEY_COMPILER, new ArrayList<String>(Arrays.asList(KEY_COMPILER)));
        categoryToKeys.put(KEY_COMP_FLAG, new ArrayList<String>(Arrays.asList(KEY_COMP_FLAG)));
        categoryToKeys.put(KEY_COMP_FORMAT, new ArrayList<String>(Arrays.asList(KEY_COMP_FORMAT)));
        categoryToKeys.put(KEY_LINKER, new ArrayList<String>(Arrays.asList(KEY_LINKER)));
        categoryToKeys.put(KEY_LINK_FLAG, new ArrayList<String>(Arrays.asList(KEY_LINK_FLAG)));
        categoryToKeys.put(KEY_LINK_FORMAT, new ArrayList<String>(Arrays.asList(KEY_LINK_FORMAT)));
        categoryToKeys.put(CAT_MULTI_DEVICE_JTAG, new ArrayList<String>(Arrays.asList(KEY_JTAG_DEVICES_AFTER_TARGET, KEY_JTAG_DEVICES_BEFORE_TARGET, KEY_JTAG_BITS_AFTER_TARGET_IR, KEY_JTAG_BITS_BEFORE_TARGET_IR)));
        categoryToKeys.put(KEY_OUTPUT_FILE, new ArrayList<String>(Arrays.asList(KEY_OUTPUT_FILE)));
        categoryToKeys.put(KEY_MAKE_FILE, new ArrayList<String>(Arrays.asList(KEY_MAKE_FILE)));
        categoryToKeys.put(KEY_HEX_GENERATOR, new ArrayList<String>(Arrays.asList(KEY_HEX_GENERATOR)));
        categoryToKeys.put(KEY_GEN_HEX, new ArrayList<String>(Arrays.asList(KEY_GEN_HEX)));
        categoryToKeys.put(KEY_C_EXT, new ArrayList<String>(Arrays.asList(KEY_C_EXT)));
        categoryToKeys.put(KEY_EC_PROTOCOL, new ArrayList<String>(Arrays.asList(KEY_EC_PROTOCOL)));
        categoryToKeys.put(KEY_C2_STROBE_TIME, new ArrayList<String>(Arrays.asList(KEY_C2_STROBE_TIME)));
        categoryToKeys.put(KEY_ADAPTER, new ArrayList<String>(Arrays.asList(KEY_ADAPTER)));
        categoryToKeys.put(KEY_ADAPTER_SN, new ArrayList<String>(Arrays.asList(KEY_ADAPTER_SN)));
        categoryToKeys.put(KEY_USB_ADAPTER_POWER, new ArrayList<String>(Arrays.asList(KEY_USB_ADAPTER_POWER)));
        categoryToKeys.put(CAT_A_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        categoryToKeys.put(CAT_C_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        categoryToKeys.put(CAT_L_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        categoryToKeys.put(CAT_P_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        categoryToKeys.put(CAT_BANK_MAP, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME, KEY_BANK_NUM)));
        categoryToKeys.put(CAT_FOLDERS, new ArrayList<String>(Arrays.asList(KEY_FOLDER_NAME)));
        categoryToKeys.put(CAT_SOURCE_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        categoryToKeys.put(CAT_HEADER_FILES, new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
        dynamicCategories = new HashMap<String, String>();
        dynamicCategories.put(CAT_FOLDERS, KEY_FILE_NAME);
    }

    public WSPFileReader(File file) {
        this.file = file;
        this.dynamicCategoryToKeys = new LinkedHashMap<String, List<String>>(categoryToKeys);
    }

    public Object parse() throws IOException {
        this.results = new LinkedHashMap<String, Map<String, List<String>>>();
        if (this.file != null) {
            String currentCategory = null;
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader lineReader = new BufferedReader(new FileReader(this.file));){
                String line = lineReader.readLine();
                while (line != null) {
                    currentCategory = this.handleLine(currentCategory, line);
                    line = lineReader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.removeEmptyCategories();
        }
        if (RuntimeUtils.isJUnitRunning()) {
            this.printResults();
        }
        return this.results;
    }

    private void printResults() {
        for (Map.Entry<String, Map<String, List<String>>> entry : this.results.entrySet()) {
            System.out.println(entry.getKey());
            for (Map.Entry<String, List<String>> valueEntry : entry.getValue().entrySet()) {
                System.out.println("\t" + String.valueOf(valueEntry));
            }
        }
    }

    public List<String> getData(String category, String key) {
        Map<String, List<String>> map = this.results.get(category);
        if (map != null) {
            return Collections.unmodifiableList(map.get(key));
        }
        return Collections.emptyList();
    }

    public List<String> getData(String category) {
        Map<String, List<String>> map = this.results.get(category);
        if (map == null) {
            return Collections.emptyList();
        }
        assert (map.size() == 1);
        return Collections.unmodifiableList(map.values().iterator().next());
    }

    private String handleLine(String currentCategoryPattern, String line) {
        Matcher mappingMatcher;
        Matcher categoryMatcher = categoryPattern.matcher(line);
        if (categoryMatcher.matches()) {
            currentCategoryPattern = this.handleCategoryLine(categoryMatcher.group(1));
        } else if (currentCategoryPattern != null && (mappingMatcher = mappingPattern.matcher(line)).matches()) {
            this.handleMapping(currentCategoryPattern, mappingMatcher.group(1), mappingMatcher.group(2));
        }
        return currentCategoryPattern;
    }

    private String handleCategoryLine(String category) {
        String categoryPattern = WSPFileReader.findPattern(category, this.dynamicCategoryToKeys.keySet());
        if (categoryPattern != null) {
            this.results.computeIfAbsent(categoryPattern, s -> new HashMap());
            return categoryPattern;
        }
        return null;
    }

    private static String findPattern(String string, Collection<String> patterns) {
        for (String pattern : patterns) {
            if (!string.matches(pattern)) continue;
            return pattern;
        }
        return null;
    }

    private void handleMapping(String categoryPattern, String key, String value) {
        List<String> currentKeys = this.dynamicCategoryToKeys.get(categoryPattern);
        if (WSPFileReader.findPattern(key, currentKeys) != null) {
            Map<String, List<String>> currentMap = this.results.get(categoryPattern);
            assert (currentMap != null);
            List<String> list = currentMap.get(categoryPattern);
            if (list == null) {
                list = new ArrayList<String>();
                currentMap.put(categoryPattern, list);
            }
            list.add(value);
            if (WSPFileReader.findPattern(categoryPattern, dynamicCategories.keySet()) != null) {
                this.dynamicCategoryToKeys.put(MessageFormat.format("{0}.{1}.*", value, KEY_FILE_NAME), new ArrayList<String>(Arrays.asList(KEY_FILE_NAME)));
            }
        }
    }

    private void removeEmptyCategories() {
        for (Map.Entry<String, Map<String, List<String>>> entry : new HashSet<Map.Entry<String, Map<String, List<String>>>>(this.results.entrySet())) {
            if (!entry.getValue().isEmpty()) continue;
            this.results.remove(entry.getKey());
        }
    }
}

