/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.modules;

import com.silabs.ss.framework.project.api.core.engine.ProjectModelModuleUtils;
import com.silabs.ss.framework.project.api.core.modules.IModuleDescriptor;
import com.silabs.ss.framework.project.api.core.modules.IModuleDetector;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseDetector;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.PerformanceMetadata;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SDKModuleDetector
extends BaseDetector<IModuleDescriptor>
implements IModuleDetector {
    public SDKModuleDetector() {
        super("Scanning modules...", IModuleDescriptor.class);
    }

    protected void detectInDirectory(List<IModuleDescriptor> descs, File dir) {
    }

    protected void quickScan(List<IModuleDescriptor> descs, IProgressMonitor monitor) {
        StopWatch stopWatch = PerformanceManager.INSTANCE.logStartMap(LoggingFeature.ALL, "BGBuildToolchainDetector.quickScan", null, () -> PerformanceMetadata.builder().put("class", (Object)this.getClass().getName()).build());
        String[] sdkIds = SDK.manager().findEnabledIds();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning SDKs for modules", (int)sdkIds.length);
        String[] stringArray = sdkIds;
        int n = sdkIds.length;
        int n2 = 0;
        while (n2 < n) {
            String sdkId = stringArray[n2];
            ISDKDescriptor sdk = (ISDKDescriptor)SDK.manager().findDescriptor(sdkId);
            if (sdk != null) {
                this.scanForSDK(descs, (IProgressMonitor)subMonitor.newChild(1), sdk);
            }
            ++n2;
        }
        PerformanceManager.INSTANCE.logEnd(stopWatch);
    }

    public IModuleDescriptor[] detectDescriptors(Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException {
        if (this.shouldScan(parameters, "parentId")) {
            ArrayList<IModuleDescriptor> descs = new ArrayList<IModuleDescriptor>();
            String sdkId = (String)parameters.get("parentId");
            ISDKDescriptor sdk = (ISDKDescriptor)SDK.manager().findDescriptor(sdkId);
            if (sdk != null) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scanning SDK for modules: " + sdk.getLabel()), (int)1);
                this.scanForSDK(descs, (IProgressMonitor)subMonitor.newChild(1), sdk);
                return descs.toArray(new IModuleDescriptor[descs.size()]);
            }
        }
        return (IModuleDescriptor[])super.detectDescriptors(parameters, monitor);
    }

    protected boolean shouldScan(Map<String, Object> parameters, String key) {
        if ("parentId".equals(key)) {
            return parameters.get(key) != null;
        }
        return super.shouldScan(parameters, key);
    }

    protected void scanForSDK(List<IModuleDescriptor> descs, IProgressMonitor monitor, ISDKDescriptor sdk) {
        List modulesFiles = (List)sdk.getProperty(SDKProperties.MODULES_FILES);
        if (modulesFiles != null) {
            try {
                modulesFiles.forEach(modulesFile -> this.loadModuleFile(descs, sdk, (IPath)modulesFile));
            }
            catch (Exception e) {
                Activator.reporter.logError("Failed to load modules from " + sdk.getLabel(), (Throwable)e);
            }
        }
        monitor.done();
    }

    private void loadModuleFile(List<IModuleDescriptor> descs, ISDKDescriptor sdk, IPath modulesFile) {
        if (modulesFile == null) {
            return;
        }
        descs.addAll(ProjectModelModuleUtils.loadModulesFromXML(modulesFile, writeable -> {
            writeable.setProperty(CoreProperties.BUILTIN, (Object)true);
            writeable.setProperty(CoreProperties.VERSION, (Object)sdk.getVersion());
            writeable.setProperty(SDKProperties.CONTRIBUTING_SDK, (Object)sdk.getId());
        }));
    }
}

