/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core;

import com.silabs.ss.framework.project.api.core.ISelectableWriteableDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.rcp.core.analytics.AnalyticsLogger;
import org.json.JSONStringer;

public class ImportAnalyticsData {
    private static final String EVENT_TYPE_IMPORT = "import_project";

    public static void logBuild(IImportProjectDescriptor projectDesc) {
        try {
            AnalyticsLogger.log((String)EVENT_TYPE_IMPORT, () -> ImportAnalyticsData.getJSON(projectDesc), (Boolean)false);
        }
        catch (Throwable e) {
            Activator.reporter.logError("Failed to log project import", e);
        }
    }

    private static String getJSON(IImportProjectDescriptor projectDesc) {
        ISelectableWriteableDescriptor currentConfig = projectDesc.getCurrentConfigurationDescriptor();
        if (currentConfig == null) {
            currentConfig = projectDesc;
        }
        return new JSONStringer().object().key("id").value((Object)projectDesc.getId()).key("name").value((Object)projectDesc.getName()).key("projectType").value((Object)projectDesc.getExternalProjectType()).key("partId").value((Object)currentConfig.getPartId()).key("boardIds").value((Object)currentConfig.getBoardIds()).key("toolchainId").value((Object)currentConfig.getToolchainId()).key("sdkId").value((Object)currentConfig.getSdkId()).endObject().toString();
    }
}

