/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngine;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ProjectEngineSession
implements IProjectEngineSession {
    private IProjectDescriptor projectDescriptor;
    private IProjectModel projectModel;
    private URI projectRoot;
    private URI contentRoot;
    private Map<Object, IPath> entryPaths = new HashMap<Object, IPath>();
    private IProjectModelEngine engine;

    public ProjectEngineSession(IProjectModelEngine engine, IProjectModel projectModel, IProjectDescriptor projectDescriptor) {
        this.engine = engine;
        this.projectModel = projectModel;
        this.projectDescriptor = projectDescriptor;
        this.projectRoot = projectDescriptor.getProjectDescriptionLocationURI();
        if (this.projectRoot == null) {
            throw new IllegalArgumentException("no project creation location");
        }
        try {
            String contentRootStr = projectModel.getModel().getContentRoot();
            this.contentRoot = TextUtils.isEmpty((String)contentRootStr) || ".".equals(contentRootStr) || "./".equals(contentRootStr) ? this.projectRoot : URIUtils.resolveURIToPath((URI)projectModel.getContentRootURI()).toFile().toURI();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("bad content root", e);
        }
        if (this.contentRoot == null) {
            throw new IllegalArgumentException("no content root");
        }
    }

    @Override
    public IProjectDescriptor getProjectDescriptor() {
        return this.projectDescriptor;
    }

    @Override
    public IProjectModel getProjectModel() {
        return this.projectModel;
    }

    @Override
    public URI getContentRoot() {
        return this.contentRoot;
    }

    @Override
    public URI getProjectRoot() {
        return this.projectRoot;
    }

    @Override
    public IPath getProjectPath(MEntry entry) {
        MEntry key = entry;
        Object projPath = this.entryPaths.get(key);
        if (projPath == null) {
            if (entry == null || entry instanceof MProject) {
                return Path.EMPTY;
            }
            String entName = this.getProjectModel().resolveString(entry.getName());
            projPath = entry.eContainer() instanceof MProject ? new Path(entName) : this.getProjectPath((MEntry)entry.eContainer()).append(entName);
            if (entry instanceof MFolderEntry) {
                projPath = projPath.addTrailingSeparator();
            }
            projPath = projPath.makeAbsolute();
            this.entryPaths.put(key, (IPath)projPath);
        }
        return projPath;
    }

    @Override
    public IProjectModelEngine getProjectEngine() {
        return this.engine;
    }
}

