/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.variables.ChainedVariableLookup;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngine;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModel;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngine;
import java.net.URI;

public class ProjectModelEngineFactory
implements IProjectModelEngineFactory {
    @Override
    public IProjectModel createProjectModel(MProject model, IVariableLookup lookup) {
        return new ProjectModel(model, lookup);
    }

    @Override
    public IProjectModel createExistingProjectModel(MProject model, IVariableLookup variableLookup, URI uri, MProjectResourceTree projectResourceTree) {
        return new ProjectModel(model, variableLookup, uri, projectResourceTree);
    }

    @Override
    public IProjectModel createProjectModelWithLookup(IProjectModel model, IVariableLookup variableLookup) {
        ProjectModel pm = new ProjectModel(model.getModel(), (IVariableLookup)new ChainedVariableLookup(variableLookup, model.getVariableLookup()), model.getContentRootURI(), model.getProjectResourceTree());
        pm.setRawModel(model.getRawModel());
        return pm;
    }

    @Override
    public IProjectModel createUserProjectModel(MProject userModel, IProjectModel rawModel) {
        ProjectModel model = new ProjectModel(userModel, rawModel.getVariableLookup(), rawModel.getContentRootURI(), rawModel.getProjectResourceTree());
        model.setRawModel(rawModel);
        return model;
    }

    @Override
    public IProjectModelEngine createProjectModelEngine(IProjectModel model) {
        return new ProjectModelEngine(model);
    }

    @Override
    public IProjectModelEngine createProjectModelEngine(IProjectModel rawModel, IProjectModel userModel) {
        return new ProjectModelEngine(rawModel, userModel);
    }
}

