/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.GenericBuildOptions;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingEngine;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.type.IProjectToolOptionHandler;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.api.toolchain.core.IToolOption;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ProjectModelOptionEngine
extends ProjectModelSwitchRecurser<Object> {
    private static final String DEFAULT_STATE = "%DEFAULT_STATE%";
    private Map<String, Collection<IGenericOptionMappingRegistry>> mappers;

    public static void resolveToolOptions(IProjectDescriptor projDesc, MProject project) {
        IProjectToolOptionHandler optHandler = (IProjectToolOptionHandler)projDesc.getProjectType().getAdapter(IProjectToolOptionHandler.class);
        ProjectModelOptionEngine.doResolveToolOptions(projDesc, project, optHandler);
    }

    public static Collection<MToolOption> resolveToolOptions(Collection<IOptionMappingEngine> mappers, Collection<IToolOption> opts) {
        Collection toolOpts = opts.stream().map(o -> {
            ProjectModelObjFactory.CreateMToolOption toolOpt = ProjectModelObjFactory.forMToolOption(o.getToolIdPattern(), o.getOptionIdRepl()).setValue(o.getValueRepl());
            o.getListValues().forEach(toolOpt::addListOption);
            return (MToolOption)toolOpt.get();
        }).collect(Collectors.toList());
        return new ProjectModelOptionEngine().convertOptions(mappers, toolOpts, Collections.emptyList());
    }

    public static void doResolveToolOptions(IProjectDescriptor projDesc, MProject project, IProjectToolOptionHandler optHandler) {
        Map<String, Collection<IGenericOptionMappingRegistry>> descToEngine = Stream.of(projDesc.getBuildConfigurationDescriptors()).collect(Collectors.toMap(desc -> ProjectModelUtils.findOrAddNewConfigurationFor(project, desc).getId(), desc -> ProjectModelOptionEngine.loadMappingEngine(optHandler, projDesc, desc)));
        descToEngine.put(DEFAULT_STATE, ProjectModelOptionEngine.loadMappingEngine(optHandler, projDesc, projDesc));
        new ProjectModelOptionEngine(descToEngine).doSwitch((EObject)project);
    }

    private static Collection<IGenericOptionMappingRegistry> loadMappingEngine(IProjectToolOptionHandler optHandler, IProjectDescriptor projDesc, ISelectableDescriptor context) {
        if (optHandler == null) {
            return Collections.emptyList();
        }
        return optHandler.getGenericOptionMappingRegistry(projDesc, context).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ProjectModelOptionEngine() {
        this(Collections.emptyMap());
    }

    private ProjectModelOptionEngine(Map<String, Collection<IGenericOptionMappingRegistry>> registries) {
        this.mappers = registries;
    }

    public Object caseMSettingsSite(MSettingsSite site) {
        Collection<IOptionMappingEngine> engines = this.getEngines(site);
        this.convertOptions(engines, (Collection<MToolOption>)site.getToolOptions(), (Collection<MConvertedOption>)site.getConvertedOptions());
        return null;
    }

    private Collection<IOptionMappingEngine> getEngines(MSettingsSite site) {
        Collection engines;
        MDescriptor settings = this.recursiveFindConfig((EObject)site);
        if (settings instanceof MConfiguration) {
            engines = this.mappers.computeIfAbsent(settings.getId(), k -> this.mappers.get(DEFAULT_STATE));
        } else {
            if (!(settings instanceof MProject)) {
                if (settings != null) {
                    throw new IllegalStateException("Should not get here");
                }
            }
            engines = this.mappers.keySet().stream().filter(k -> !DEFAULT_STATE.equals(k)).map(this.mappers::get).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        return engines.stream().filter(Objects::nonNull).distinct().map(IOptionMappingRegistry::createOptionMappingEngine).collect(Collectors.toList());
    }

    private MDescriptor recursiveFindConfig(EObject site) {
        if (site instanceof MProject) {
            return (MProject)site;
        }
        if (site instanceof MConfiguration) {
            return (MConfiguration)site;
        }
        if (site == null) {
            return null;
        }
        return this.recursiveFindConfig(site.eContainer());
    }

    private Collection<MToolOption> convertOptions(Collection<IOptionMappingEngine> mappers, Collection<MToolOption> stocks, Collection<MConvertedOption> opts) {
        if (stocks.isEmpty() && opts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MToolOption> newStocks = new ArrayList<MToolOption>(stocks);
        MSettingsSite site = ProjectModelFactory.eINSTANCE.createMSettingsSite();
        site.getConvertedOptions().addAll(EcoreUtil.copyAll(opts));
        Iterator<MToolOption> iter = newStocks.iterator();
        while (iter.hasNext()) {
            MToolOption origStock = iter.next();
            List<MGenericOption> newOpts = this.createConvertedOpts(origStock);
            if (newOpts == null) continue;
            iter.remove();
            site.getConvertedOptions().addAll(newOpts);
        }
        Collection specifics = mappers.stream().map(m -> {
            MSettingsSite newSite = (MSettingsSite)EcoreUtil.copy((EObject)site);
            m.exportOptions(newSite);
            return newSite.getConvertedOptions();
        }).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        if (specifics.isEmpty()) {
            specifics = site.getConvertedOptions().stream().flatMap(this::convertDefaults).collect(Collectors.toList());
        }
        List<MToolOption> toolOpts = ProjectModelOptionEngine.convertToToolOpts(specifics).options();
        newStocks.addAll(0, toolOpts);
        stocks.clear();
        stocks.addAll(newStocks);
        return newStocks;
    }

    public static OptionList convertToToolOpts(Collection<MConvertedOption> specifics) {
        MSettingsSite newSite = ProjectModelFactory.eINSTANCE.createMSettingsSite();
        OptionList optionList = new OptionList();
        for (MConvertedOption spec : specifics) {
            ProjectModelObjFactory.CreateMToolOption newOption = ProjectModelObjFactory.forMToolOption(spec.getToolId(), spec.getOptionId());
            IProperty specOpt = (IProperty)Property.registry().findDescriptor(spec.getOptionId());
            if (ProjectModelOptionEngine.shouldBeToolList(spec, specOpt)) {
                ((ProjectModelObjFactory.CreateMToolOption)newOption.findOrApply(newSite)).convertToListOptions();
                StreamUtils.createStream((Object)spec.getValue()).map(v -> ProjectModelOptionEngine.stringizeValue(specOpt, v)).forEachOrdered(v -> {
                    ProjectModelObjFactory.CreateMToolOption createMToolOption2 = newOption.newListOption((String)v).applySelectable((MSelectable)spec).apply();
                });
            } else if (ProjectModelOptionEngine.isGenericToolList(spec)) {
                Object oldVal = ((MToolOption)((ProjectModelObjFactory.CreateMToolOption)newOption.findOrApply(newSite)).get()).getValue();
                oldVal = oldVal == null ? "" : (String)oldVal + " ";
                newOption.setValue((String)oldVal + ProjectModelOptionEngine.stringizeValue(specOpt, spec.getValue())).appendSelectable((MSelectable)spec);
            } else {
                ((ProjectModelObjFactory.CreateMToolOption)newOption.setValue(ProjectModelOptionEngine.stringizeValue(specOpt, spec.getValue())).applySelectable((MSelectable)spec)).apply(newSite);
            }
            optionList.put((MToolOption)newOption.get(), spec);
        }
        return optionList;
    }

    private List<MGenericOption> createConvertedOpts(MToolOption origStock) {
        IProperty genOpt = GenericBuildOptions.registry().findGenericOption(origStock.getToolId(), origStock.getOptionId());
        if (genOpt != null) {
            if (origStock.getToolListOptions().size() > 0) {
                return origStock.getToolListOptions().stream().map(t -> this.formatAndAddGeneric(genOpt, t.getValue(), (MSelectable)t)).collect(Collectors.toList());
            }
            return Arrays.asList(this.formatAndAddGeneric(genOpt, origStock.getValue(), (MSelectable)origStock));
        }
        return null;
    }

    private Stream<? extends MConvertedOption> convertDefaults(MConvertedOption option) {
        if (option instanceof MSpecificOption && !((MSpecificOption)option).getGenericMappings().isEmpty()) {
            return ((MSpecificOption)option).getGenericMappings().stream();
        }
        return Stream.of(option);
    }

    private static boolean shouldBeToolList(MConvertedOption spec, IProperty specOpt) {
        if (spec.getValue() instanceof Collection) {
            return true;
        }
        if (specOpt == null) {
            return false;
        }
        return specOpt.getType().getDefaultValue() instanceof Collection;
    }

    private static boolean isGenericToolList(MConvertedOption spec) {
        if (!(spec instanceof MSpecificOption)) {
            return false;
        }
        EList genMappings = ((MSpecificOption)spec).getGenericMappings();
        if (!genMappings.isEmpty()) {
            for (MGenericOption gen : genMappings) {
                IProperty genProp = GenericBuildOptions.registry().findGenericOption(gen.getToolId(), gen.getOptionId());
                if (genProp == null || !(genProp.getType().getDefaultValue() instanceof Collection)) continue;
                return true;
            }
        }
        return false;
    }

    private static String stringizeValue(IProperty specOpt, Object value) {
        String strValue = specOpt != null ? PropertyConversionUtils.stringizeValue((IProperty)specOpt, (Object)value) : (value != null ? String.valueOf(value) : null);
        return strValue;
    }

    private MGenericOption formatAndAddGeneric(IProperty genOpt, String value, MSelectable select) {
        return (MGenericOption)((ProjectModelObjFactory.CreateMGenericOption)((ProjectModelObjFactory.CreateMGenericOption)((ProjectModelObjFactory.CreateMGenericOption)ProjectModelObjFactory.forMGenericOption(genOpt).setValue(value)).validateValue()).applySelectable(select)).get();
    }

    public static class OptionList {
        private final Multimap<IdentityWrapper<MToolOption>, MConvertedOption> optionMap = LinkedHashMultimap.create();

        private OptionList() {
        }

        public boolean put(MToolOption opt, MConvertedOption conOpt) {
            return this.optionMap.put(new IdentityWrapper<MToolOption>(opt), (Object)conOpt);
        }

        public List<MToolOption> options() {
            return this.optionStream().collect(Collectors.toList());
        }

        public Stream<MToolOption> optionStream() {
            return this.optionMap.keys().stream().map(w -> (MToolOption)w.object);
        }

        public Collection<MConvertedOption> get(MToolOption opt) {
            return this.optionMap.get(new IdentityWrapper<MToolOption>(opt));
        }

        private static class IdentityWrapper<T> {
            private final T object;

            public IdentityWrapper(T object) {
                this.object = object;
            }

            public int hashCode() {
                return System.identityHashCode(this.object);
            }

            public boolean equals(Object obj) {
                if (obj instanceof IdentityWrapper) {
                    return ((IdentityWrapper)obj).object == this.object;
                }
                return obj == this.object;
            }

            static /* synthetic */ Object access$0(IdentityWrapper identityWrapper) {
                return identityWrapper.object;
            }
        }
    }
}

