/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.ObjectUtils;
import com.silabs.java.utils.Pair;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ModuleReference;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelModuleUtils;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.modules.IModule;
import com.silabs.ss.framework.project.api.core.modules.IModuleDescriptor;
import com.silabs.ss.framework.project.api.core.modules.IModuleManager;
import com.silabs.ss.framework.project.api.core.modules.Module;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Version;

public class ProjectModuleAccessor {
    private IModuleManager modMgr;
    private IProjectDescriptor projDesc;
    private IProjectModel userModel;
    private MultiStatus multiStatus;
    private Map<String, IProjectModel> fetchedModuleModels = new LinkedHashMap<String, IProjectModel>();
    private Map<String, MProject> pdms;
    private Collection<String> fetchedPdms = new ArrayList<String>();
    private Map<String, VistedModuleRef> visitedModules = new LinkedHashMap<String, VistedModuleRef>();
    private boolean hasResetSync = false;

    public static String getVersionedModuleId(String sdkId, String moduleId, boolean isPDM) {
        ISDKDescriptor sdk;
        if (isPDM) {
            return moduleId;
        }
        if (moduleId.contains(":")) {
            moduleId = (String)DescriptorUtils.parseVersionFromId((String)moduleId).first();
        }
        if ((sdk = (ISDKDescriptor)SDK.manager().findCompatibleDescriptor(sdkId)) == null) {
            return moduleId;
        }
        String versionedId = moduleId + ":" + sdk.getVersionString();
        String unVersionedId = moduleId + ":" + String.valueOf(Version.emptyVersion);
        if (Module.manager().findDescriptor(versionedId) == null && Module.manager().findDescriptor(unVersionedId) != null) {
            return unVersionedId;
        }
        return versionedId;
    }

    public static Collection<IModuleDescriptor> getAllDescriptorsForSDK(String sdkId) {
        ISDKDescriptor sdk = (ISDKDescriptor)SDK.manager().findCompatibleDescriptor(sdkId);
        Version sdkVers = sdk == null ? Version.emptyVersion : sdk.getVersion();
        HashMap map = new HashMap();
        ((Stream)Stream.of((IModuleDescriptor[])Module.manager().getAllDescriptors()).parallel()).filter(module -> ObjectUtils.equals((Object)module.getVersion(), (Object)sdkVers) || Version.emptyVersion.equals((Object)module.getVersion())).forEach(module -> {
            IModuleDescriptor mod = (IModuleDescriptor)map.get(module.getUnversionedId());
            if (mod == null || Version.emptyVersion.equals((Object)mod.getVersion())) {
                map.put(module.getUnversionedId(), module);
            }
        });
        return map.values();
    }

    public ProjectModuleAccessor(IProjectDescriptor projDesc, IProjectModel userModel, MultiStatus multiStatus) {
        this.projDesc = projDesc;
        this.userModel = userModel;
        this.multiStatus = multiStatus;
        this.modMgr = (IModuleManager)projDesc.getAdapter(IModuleManager.class);
        this.setupPDMs();
    }

    private void setupPDMs() {
        this.pdms = this.userModel.getModel().getProjectDefinedModules().stream().collect(Collectors.toMap(MProject::getPdmId, MProject::copy, (m1, m2) -> {
            if (!Objects.equals(m1, m2)) {
                Activator.reporter.logError("Multiple PDMs found with different content!");
            }
            return m2;
        }));
        for (MProject pdm : this.pdms.values()) {
            for (MToolOption toolOpt : pdm.getToolOptions()) {
                IProperty property = StudioExporterUtils.findProperty(toolOpt.getToolId(), toolOpt.getOptionId());
                if (property == null) continue;
                toolOpt.setOptionId(property.getId());
            }
        }
    }

    public boolean isValid() {
        if (this.modMgr != null) {
            return true;
        }
        this.multiStatus.add(Activator.reporter.newErrorStatus("no module manager found from " + String.valueOf(this.projDesc)));
        return false;
    }

    public Collection<String> getVisitedPdmIds() {
        return this.fetchedPdms;
    }

    public Collection<IModuleReference> getVisitedModules(IDescriptor desc, Map<String, Set<String>> builtinSourcesMap, Map<String, Set<String>> builtinExcludesMap) {
        if (this.visitedModules == null) {
            return Collections.emptyList();
        }
        return this.visitedModules.values().parallelStream().filter(ref -> desc.getId().equals(ref.desc.getId())).map(VistedModuleRef::createReference).map(modRef -> this.loadReferenceFromMap(desc, (IModuleReference)modRef, builtinSourcesMap, modRef.getBuiltinSources())).map(modRef -> this.loadReferenceFromMap(desc, (IModuleReference)modRef, builtinExcludesMap, modRef.getBuiltinExcludes())).collect(Collectors.toList());
    }

    private MModule formatModuleId(ISelectableDescriptor desc, MModule module) {
        MModule newModule = (MModule)EcoreUtil.copy((EObject)module);
        if (!module.isPdm()) {
            Pair parsedId = DescriptorUtils.parseVersionFromId((String)module.getId());
            newModule.setId((String)parsedId.first);
        }
        return newModule;
    }

    private IModuleReference loadReferenceFromMap(IDescriptor desc, IModuleReference modRef, Map<String, Set<String>> map, Collection<String> refBuiltins) {
        String moduleKey = ProjectModuleAccessor.getModuleKey(desc, modRef.getModule());
        Set<String> builtins = map.get(moduleKey);
        if (builtins != null) {
            builtins.stream().sorted().forEachOrdered(refBuiltins::add);
        }
        return modRef;
    }

    public IProjectModel getClientModule(ISelectableDescriptor desc, String moduleId, MModule mmodule) {
        if (!this.registerModule(desc, mmodule, false)) {
            return null;
        }
        return this.getModuleForMerging(desc, mmodule, moduleId);
    }

    public boolean registerRemovedModule(ISelectableDescriptor desc, MModule mmodule) {
        return this.registerModule(desc, mmodule, true);
    }

    private boolean registerModule(ISelectableDescriptor desc, MModule mmodule, boolean isRemoved) {
        String key = ProjectModuleAccessor.getModuleKey((IDescriptor)desc, mmodule);
        if (this.visitedModules.containsKey(key)) {
            return false;
        }
        this.visitedModules.put(key, new VistedModuleRef(desc, mmodule, isRemoved));
        return true;
    }

    public static String getModuleKey(IDescriptor desc, MModule mmodule) {
        return ProjectModuleAccessor.getModuleKey(desc, mmodule.getId());
    }

    public static String getModuleKey(IDescriptor desc, String moduleId) {
        return desc.getId() + ":" + (String)DescriptorUtils.parseVersionFromId((String)moduleId).first;
    }

    private IProjectModel getModuleForMerging(ISelectableDescriptor desc, MModule mmodule, String moduleId) {
        String versionedId = this.getVersionedModuleId(desc, mmodule, moduleId);
        return this.getModuleForMerging(versionedId, mmodule);
    }

    private IProjectModel getModuleForMerging(String versionedId, MModule mmodule) {
        IProjectModel clientModel;
        if (this.fetchedModuleModels.containsKey(versionedId)) {
            return this.fetchedModuleModels.get(versionedId);
        }
        if (mmodule.isPdm()) {
            MProject project = this.pdms.get(versionedId);
            if (project == null) {
                this.multiStatus.add(Activator.reporter.newErrorStatus("Failed to load project defined module " + versionedId + " from project " + this.projDesc.getName(), (Throwable)ExceptionUtils.newMinimalStackException()));
                return null;
            }
            clientModel = this.loadPDM(project);
            this.fetchedPdms.add(project.getPdmId());
        } else {
            clientModel = this.fetchManagerModule(versionedId);
        }
        if (clientModel != null) {
            this.updateModuleForMerge(clientModel);
            this.fetchedModuleModels.put(versionedId, clientModel);
        }
        return clientModel;
    }

    private String getVersionedModuleId(ISelectableDescriptor desc, MModule mmodule, String moduleId) {
        String sdkId = desc.getSdkId();
        if (sdkId == null && desc instanceof IProjectDescriptor) {
            IBuildConfigurationDescriptor[] bconfs = ((IProjectDescriptor)desc).getBuildConfigurationDescriptors();
            sdkId = bconfs.length > 0 ? bconfs[0].getSdkId() : null;
        }
        return ProjectModuleAccessor.getVersionedModuleId(sdkId, moduleId, mmodule.isPdm());
    }

    private IProjectModel loadPDM(MProject project) {
        IProjectModel pdmModel = null;
        try {
            pdmModel = ProjectModelModuleUtils.createModuleModel(project, this.userModel.getVariableLookup());
            URI contentRoot = URIUtils.resolveURIFrom((URI)this.userModel.getContentRootURI(), (URI)pdmModel.getContentRootURI());
            pdmModel.setContentRootURI(contentRoot);
        }
        catch (IOException | CoreException e) {
            this.multiStatus.add(Activator.reporter.newErrorStatus("Failed to load project defined module " + project.getId() + " from project " + project.getName(), e));
        }
        return pdmModel;
    }

    protected IProjectModel fetchManagerModule(String moduleId) {
        IModule module = (IModule)this.modMgr.find(moduleId);
        if (module == null && !this.hasResetSync) {
            this.modMgr.resetSync();
            module = (IModule)this.modMgr.find(moduleId);
            this.hasResetSync = true;
        }
        if (module == null) {
            module = DescriptorUtils.sortByBestDescriptor((IRegistry)this.modMgr, (String)moduleId).stream().map(arg_0 -> ((IModuleManager)this.modMgr).find(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
            if (module == null) {
                this.multiStatus.add(Activator.reporter.newErrorStatus("No module found for module id: " + moduleId));
                return null;
            }
            this.multiStatus.add(Activator.reporter.newWarningStatus("Exact module not found for: " + moduleId + " using module: " + module.getId()));
        }
        IProjectModel clientModel = null;
        try {
            clientModel = module.createClientProjectModel(this.userModel.getVariableLookup());
        }
        catch (CoreException e) {
            this.multiStatus.add(e.getStatus());
        }
        return clientModel;
    }

    private void updateModuleForMerge(IProjectModel clientModel) {
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMSelectable(MSelectable sel) {
                sel.setBuiltin(true);
                return null;
            }
        }.doSwitch((EObject)clientModel.getModel());
        ProjectModelMergeUtils.propagateSettingsIntoConfigurations(clientModel.getModel());
    }

    private final class VistedModuleRef {
        private ISelectableDescriptor desc;
        private MModule module;
        private boolean isRemoved;

        public VistedModuleRef(ISelectableDescriptor desc, MModule module, boolean isRemoved) {
            this.desc = desc;
            this.module = module;
            this.isRemoved = isRemoved;
        }

        public IModuleReference createReference() {
            MModule newModule = ProjectModuleAccessor.this.formatModuleId(this.desc, this.module);
            ModuleReference modRef = new ModuleReference(newModule);
            modRef.setRemoved(this.isRemoved);
            return modRef;
        }
    }
}

