/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.migrator;

import com.silabs.ss.framework.project.internal.core.migrator.RegExStringMigrator;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.SDK;

public class DefaultSdkIdMigrator
extends RegExStringMigrator {
    private static final String SDK_8051_ID = "com.silabs.sdk.8051";
    private static final String PREFERRED_8051_VERSION = "com.silabs.sdk.8051:4.0.0";
    private static final String SDK_8051_ID_EXPR = "com\\.silabs\\.sdk\\.si8051.*";
    private static final String SDK_EXX32_ID = "com.silabs.sdk.exx32";
    private static final String PREFERRED_EFM32_VERSION = "com.silabs.sdk.exx32:4.4.0";
    private static final String SDK_EFM32_ID_EXPR = "com\\.silabs\\.sdk\\.si32\\.efm32.*";
    private String[][] mappings = new String[3][2];

    public DefaultSdkIdMigrator() {
        this.mappings[0][0] = "com\\.silabs\\.ide\\.sdk\\.core\\.none.*";
        this.mappings[0][1] = "com.silabs.sdk.none:0.0.0";
        DefaultSdkIdMigrator.findAndLoadDescriptor(PREFERRED_EFM32_VERSION, SDK_EXX32_ID, this.mappings[1], SDK_EFM32_ID_EXPR);
        DefaultSdkIdMigrator.findAndLoadDescriptor(PREFERRED_8051_VERSION, SDK_8051_ID, this.mappings[2], SDK_8051_ID_EXPR);
    }

    @Override
    protected String[][] getMappings() {
        return this.mappings;
    }

    private static void findAndLoadDescriptor(String preferredId, String baseId, String[] mapping, String regex) {
        ISDKDescriptor sdk = (ISDKDescriptor)SDK.manager().findCompatibleDescriptor(preferredId);
        if (sdk == null) {
            sdk = (ISDKDescriptor)SDK.manager().findCompatibleDescriptor(baseId);
        }
        if (sdk != null) {
            mapping[0] = regex;
            mapping[1] = sdk.getId();
        }
    }
}

