/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.property;

import com.silabs.ss.framework.project.api.core.property.IDefine;
import java.util.Arrays;

public class Define
implements IDefine {
    private String macroName;
    private String[] macroArgs;
    private String expansion;

    public Define() {
    }

    public Define(String macroName, String[] macroArgs, String expansion) {
        if (macroName == null) {
            throw new IllegalArgumentException();
        }
        this.macroName = macroName;
        this.macroArgs = macroArgs;
        this.expansion = expansion != null ? expansion : "1";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.expansion == null ? 0 : this.expansion.hashCode());
        result = 31 * result + Arrays.hashCode(this.macroArgs);
        result = 31 * result + (this.macroName == null ? 0 : this.macroName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Define other = (Define)obj;
        if (this.expansion == null ? other.expansion != null : !this.expansion.equals(other.expansion)) {
            return false;
        }
        if (!Arrays.equals(this.macroArgs, other.macroArgs)) {
            return false;
        }
        return !(this.macroName == null ? other.macroName != null : !this.macroName.equals(other.macroName));
    }

    @Override
    public String[] getArgumentNames() {
        return this.macroArgs;
    }

    @Override
    public String getExpansion() {
        return this.expansion;
    }

    @Override
    public String getName() {
        return this.macroName;
    }

    @Override
    public String getPrototype() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.macroName);
        if (this.macroArgs != null) {
            builder.append('(');
            boolean first = true;
            String[] stringArray = this.macroArgs;
            int n = this.macroArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(arg);
                ++n2;
            }
            builder.append(')');
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getPrototype() + " " + this.getExpansion();
    }

    public void setName(String macroName) {
        this.macroName = macroName;
    }

    public void setArgumentNames(String[] macroArgs) {
        this.macroArgs = macroArgs;
    }

    public void setExpansion(String expansion) {
        this.expansion = expansion;
    }
}

