/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.solution.engine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.CollectionUtils;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.engine.operations.IBaseProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.ISolutionModel;
import com.silabs.ss.framework.project.api.core.solution.ISolutionPropertyApplicability;
import com.silabs.ss.framework.project.api.core.solution.SolutionFactory;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionBuildStep;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfig;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfigSettings;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionDefinition;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModule;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReferenceContainer;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionSettings;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionConfigProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.CreateSolutionConfigOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.ResetSolutionModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetGeneralPropertyOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetNameOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPrebuildStepOperation;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.solution.SolutionModel;
import com.silabs.ss.framework.project.internal.core.solution.SolutionModelUtils;
import com.silabs.ss.framework.project.internal.core.solution.engine.ISolutionModelEngine;
import com.silabs.ss.framework.project.internal.core.solution.engine.SolutionEngineSession;
import com.silabs.ss.framework.project.internal.core.solution.engine.SolutionModelMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.model.MDescribable;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptorProperties;
import com.silabs.ss.platform.api.descriptor.core.model.impl.StringToStringMapImpl;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;

public final class SolutionModelEngine
implements ISolutionModelEngine {
    private static final String DEFAULT_CONFIG_NAME = "Default";
    private final ISolutionEntity solution;
    private final ISolutionModel readOnlyUserModel;
    private final ISolutionEngineOperationHandler handler;
    private final ISolutionPropertyApplicability propAppl;
    private final Path rootPath;
    private ISolutionModel resolvedModel;
    private MultiStatus status;
    private SolutionEngineSession session;
    private Map<String, VisitedSolutionModule> visitedModules;
    private Multimap<String, VisitedSolutionModule> configToModuleMap;

    public static SolutionModelEngine create(ISolutionEntity solution, ISolutionModel model, ISolutionEngineOperationHandler handler) {
        return new SolutionModelEngine(solution, model, handler);
    }

    private SolutionModelEngine(ISolutionEntity solution, ISolutionModel model, ISolutionEngineOperationHandler handler) {
        this.solution = solution;
        this.readOnlyUserModel = model;
        this.handler = handler;
        this.rootPath = this.resolveRoot(solution);
        this.status = new MultiStatus(Activator.id(), 0, "Problems updating solution!", null);
        this.configToModuleMap = ArrayListMultimap.create();
        this.visitedModules = new HashMap<String, VisitedSolutionModule>();
        this.propAppl = SolutionModelUtils.propertyApplicability(solution);
    }

    private Path resolveRoot(ISolutionEntity sln) {
        try {
            return sln.getInstallationPath().toFile().toPath().getParent();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public MultiStatus status() {
        return this.status;
    }

    @Override
    public IStatus runSolutionUpdate(IProgressMonitor pmon) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmon, (int)4);
        this.resolvedModel = this.createResolvedModel((IProgressMonitor)monitor.split(1));
        this.expandModules((IProgressMonitor)monitor.split(1));
        this.session = new SolutionEngineSession(this.solution, this.resolvedModel, (URI)this.solution.getProperty(CoreProperties.INSTALLATION_PATH));
        Collection<IBaseProjectEngineOperation> operations = this.createOperations((IProgressMonitor)monitor.split(1));
        this.executeOperations(operations, (IProgressMonitor)monitor.split(1));
        return this.status;
    }

    private ISolutionModel createResolvedModel(IProgressMonitor pmon) {
        return new SolutionModel(this.readOnlyUserModel.getModel().copy(), null, this.readOnlyUserModel.getContentRootURI());
    }

    private void expandModules(IProgressMonitor pmon) {
        MSolution solution = this.resolvedModel.getModel();
        ImmutableMap modMap = (ImmutableMap)solution.getSolutionDefinedModules().stream().collect(ImmutableMap.toImmutableMap(MSolutionModule::getId, MSolutionModule::copy));
        Collection<VisitedSolutionModule> slnModulesToAdd = this.resolveReferences((ImmutableMap<String, MSolutionModule>)modMap, (MSolutionModuleReferenceContainer)solution);
        SolutionFactory.CreateSolution factory = SolutionFactory.edit(solution);
        slnModulesToAdd.stream().map(VisitedSolutionModule::module).map(MSolutionDefinition::getConfigs).flatMap(Collection::stream).map(MDescribable::getName).forEach(c -> {
            SolutionFactory.CreateSolution createSolution2 = factory.configuration((String)c).ifNew(f -> {
                Object CConfig = f.setBuiltin(true);
            }).commit();
        });
        if (solution.getConfigs().isEmpty()) {
            ((SolutionFactory.CreateSolutionConfiguration)factory.configuration(DEFAULT_CONFIG_NAME).setBuiltin(true)).commit();
        }
        Map slnProjectRefs = (Map)solution.getProjects().stream().collect(CollectionUtils.toMap(MSolutionProject::getName, p -> p, LinkedHashMap::new));
        slnModulesToAdd.forEach(m -> this.mergeProperties((MSolutionConfigSettings)solution, (MSolutionSettings)m.module, true));
        for (MSolutionConfig config : solution.getConfigs()) {
            this.mergeModuleContent(slnProjectRefs, (MSolutionConfigSettings)config, (MSolutionSettings)solution, false);
            Collection<VisitedSolutionModule> configModulesToAdd = this.resolveReferences((ImmutableMap<String, MSolutionModule>)modMap, (MSolutionModuleReferenceContainer)config);
            configModulesToAdd.forEach(m -> this.mergeModule(slnProjectRefs, (MSolutionConfigSettings)config, (VisitedSolutionModule)m));
            slnModulesToAdd.forEach(m -> this.mergeModule(slnProjectRefs, (MSolutionConfigSettings)config, (VisitedSolutionModule)m));
        }
        slnProjectRefs.values().forEach(p -> p.setLocation(this.relativizeProjectLocation((MSolutionProject)p)));
        solution.getProjects().clear();
        solution.getProjects().addAll(slnProjectRefs.values());
    }

    private String relativizeProjectLocation(MSolutionProject project) {
        String location = project.getLocation();
        if (location == null || this.rootPath == null) {
            return null;
        }
        Path projLoc = Path.of(location, new String[0]);
        if (!projLoc.isAbsolute()) {
            return location;
        }
        String stringPath = FileUtils.tryRelativise((Path)this.rootPath, (Path)projLoc).orElse(projLoc).toString().replace("\\", "/");
        if (TextUtils.isEmpty((String)stringPath)) {
            return ".";
        }
        return stringPath;
    }

    private void mergeModule(Map<String, MSolutionProject> slnProjectRefs, MSolutionConfigSettings config, VisitedSolutionModule module) {
        Map<String, MSolutionProject> configSlnProjects = Map.of();
        if (config instanceof MSolutionConfig) {
            MSolutionConfig moduleConfig = module.module.getConfigs().stream().filter(c -> config.getName().equals(c.getName())).findFirst().orElse(null);
            configSlnProjects = new HashMap();
            this.mergeModuleContent(configSlnProjects, config, (MSolutionSettings)moduleConfig, true);
        }
        this.mergeModuleContent(slnProjectRefs, config, (MSolutionSettings)module.module, true);
        configSlnProjects.forEach((k, p) -> {
            MSolutionProject mSolutionProject = slnProjectRefs.compute((String)k, (n, op) -> {
                if (op == null || TextUtils.isEmpty((String)op.getLocation())) {
                    return p;
                }
                return op;
            });
        });
    }

    private void mergeModuleContent(Map<String, MSolutionProject> slnProjectRefs, MSolutionConfigSettings config, MSolutionSettings module, boolean isModule) {
        if (module == null) {
            return;
        }
        Map<String, MSolutionProject> projNames = config.getProjects().stream().collect(Collectors.toMap(MSolutionProject::getName, p -> p));
        for (MSolutionProject project : module.getProjects()) {
            MSolutionProject existingProj = projNames.get(project.getName());
            if (existingProj == null) {
                existingProj = SolutionFactory.forProject(project.getName()).setBuiltin(isModule).apply((MSolutionSettings)config).getModel();
            }
            SolutionModelMergeUtils.mergeProjects(existingProj, project);
            slnProjectRefs.compute(project.getName(), (n, p1) -> {
                if (p1 == null) {
                    p1 = (MSolutionProject)EcoreTypeUtils.copy((EObject)project);
                    p1.setBuiltin(isModule);
                } else if (TextUtils.isEmpty((String)p1.getLocation())) {
                    p1.setLocation(project.getLocation());
                }
                return p1;
            });
            if (!isModule) continue;
            existingProj.setLocation(null);
        }
        if (!config.hasPreBuildStep() && module.hasPreBuildStep()) {
            config.setPrebuildStep((MSolutionBuildStep)EcoreTypeUtils.copy((EObject)module.getPrebuildStep()));
            if (isModule) {
                config.getPrebuildStep().setBuiltin(true);
            }
        }
        if (!config.hasPostBuildStep() && module.hasPostBuildStep()) {
            config.setPostbuildStep((MSolutionBuildStep)EcoreTypeUtils.copy((EObject)module.getPostbuildStep()));
            if (isModule) {
                config.getPostbuildStep().setBuiltin(true);
            }
        }
        this.mergeProperties(config, module, isModule);
    }

    private void mergeProperties(MSolutionConfigSettings config, MSolutionSettings module, boolean isModule) {
        module.getProperties().forEach(e -> {
            if (!this.propAppl.isPropertyValid((MDescriptorProperties)config, (String)e.getKey())) {
                return;
            }
            if (!config.getProperties().containsKey(e.getKey())) {
                config.putPropertyEntry((String)e.getKey(), (String)e.getValue(), isModule || ((StringToStringMapImpl)e).isBuiltin());
            }
        });
    }

    private Collection<VisitedSolutionModule> resolveReferences(ImmutableMap<String, MSolutionModule> modMap, MSolutionModuleReferenceContainer container) {
        return container.getSolutionModuleReferences().stream().map(MSolutionModuleReference::getId).map(id -> this.getModuleToVisit(modMap, container, (String)id)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private VisitedSolutionModule getModuleToVisit(ImmutableMap<String, MSolutionModule> modMap, MSolutionModuleReferenceContainer container, String moduleId) {
        VisitedSolutionModule visitedModule = this.visitedModules.computeIfAbsent(moduleId, id -> {
            MSolutionModule module = (MSolutionModule)modMap.get(id);
            if (module == null) {
                this.status.merge(Activator.reporter.newErrorStatus("Failed to find module for reference " + id));
                return null;
            }
            return new VisitedSolutionModule(module, container);
        });
        if (visitedModule == null) {
            return null;
        }
        this.configToModuleMap.put((Object)SolutionModelEngine.parentId(container), (Object)visitedModule);
        return visitedModule;
    }

    private Collection<IBaseProjectEngineOperation> createOperations(IProgressMonitor pmon) {
        ArrayList<IBaseProjectEngineOperation> operations = new ArrayList<IBaseProjectEngineOperation>();
        MSolution model = this.resolvedModel.getModel();
        operations.add(new ResetSolutionModuleReferencesOperation(this.session));
        operations.add(new SetNameOperation(this.session, model.getName(), model.getLabel()));
        this.visitedModules.values().forEach(vsdm -> {
            boolean bl = operations.add(new AddSolutionDefinedModuleOperation(this.session, vsdm.module));
        });
        this.createConfigSettingsOperations(operations, (MSolutionConfigSettings)model);
        model.getConfigs().forEach(c -> this.createConfigOperations((Collection<IBaseProjectEngineOperation>)operations, (MSolutionConfig)c));
        return operations;
    }

    private void createConfigOperations(Collection<IBaseProjectEngineOperation> operations, MSolutionConfig config) {
        operations.add(new CreateSolutionConfigOperation(this.session, config.getName(), config.isBuiltin()));
        this.createConfigSettingsOperations(operations, (MSolutionConfigSettings)config);
    }

    private void createConfigSettingsOperations(Collection<IBaseProjectEngineOperation> operations, MSolutionConfigSettings config) {
        String slnConfig = config instanceof MSolutionConfig ? config.getName() : null;
        operations.addAll(this.createProjectOperations(config));
        config.getProperties().stream().map(arg_0 -> ((Caster)Caster.with(StringToStringMapImpl.class)).cast(arg_0)).forEach(p -> {
            boolean bl = operations.add(new SetGeneralPropertyOperation(this.session, slnConfig, p.getKey(), p.getValue(), p.isBuiltin()));
        });
        operations.add(new SetSolutionConfigPostbuildStepOperation(this.session, slnConfig, config.getPostbuildStep()));
        operations.add(new SetSolutionConfigPrebuildStepOperation(this.session, slnConfig, config.getPrebuildStep()));
        if (config instanceof MSolutionModuleReferenceContainer) {
            this.configToModuleMap.get((Object)SolutionModelEngine.parentId((MSolutionModuleReferenceContainer)config)).forEach(vm -> {
                boolean bl = operations.add(new AddSolutionModuleReferenceOperation(this.session, slnConfig, vm.module.getId()));
            });
        }
    }

    private Collection<IBaseProjectEngineOperation> createProjectOperations(MSolutionConfigSettings config) {
        return config.getProjects().stream().map(project -> {
            if (config instanceof MSolution) {
                return new AddSolutionProjectOperation(this.session, project.getName(), project.getLocation(), project.isBuiltin());
            }
            return new AddSolutionConfigProjectOperation(this.session, config.getName(), project.getName(), project.getConfiguration(), project.getBinary(), project.isBuiltin());
        }).collect(Collectors.toList());
    }

    private void executeOperations(Collection<IBaseProjectEngineOperation> operations, IProgressMonitor pmon) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmon, (int)operations.size());
        for (IBaseProjectEngineOperation operation : operations) {
            try {
                operation.executeProcess(this.handler, (IProgressMonitor)monitor.split(1));
            }
            catch (CoreException e) {
                this.status.merge(Activator.reporter.newErrorStatus(e.getMessage(), (Throwable)e));
            }
        }
    }

    private static String parentId(MSolutionModuleReferenceContainer parent) {
        return parent instanceof MSolution ? "%%project%%" : ((MSolutionConfig)parent).getName();
    }

    private class VisitedSolutionModule {
        final MSolutionModule module;

        public VisitedSolutionModule(MSolutionModule module, MSolutionModuleReferenceContainer parent) {
            this.module = module;
        }

        public MSolutionModule module() {
            return this.module;
        }
    }
}

