/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.templates;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateDetector;
import com.silabs.ss.framework.project.internal.api.core.templates.TemplateUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.content.core.metadata.GeneralMetadataDetector;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MetadataTemplateDetector
extends GeneralMetadataDetector<ITemplateDescriptor>
implements ITemplateDetector {
    private static final String TEMPLATE_METADATA_FILE_EXTENSION = ".templates";

    public MetadataTemplateDetector() {
        super((GeneralMetadataDetector.IMetadataLoader)new GeneralMetadataDetector.IMetadataLoader<ITemplateDescriptor>(){

            public String getFileExtension() {
                return MetadataTemplateDetector.TEMPLATE_METADATA_FILE_EXTENSION;
            }

            public Class<? extends ITemplateDescriptor> getInterfaceClass() {
                return ITemplateDescriptor.class;
            }

            public Collection<ITemplateDescriptor> createDescriptorsFromFile(File file) {
                StopWatch stopWatch = PerformanceManager.INSTANCE.logStart(LoggingFeature.ALL, "MetadataTemplateDetector.createDescriptorsFromFile", null);
                ArrayList<ITemplateDescriptor> descs = new ArrayList<ITemplateDescriptor>();
                try {
                    StringBuilder errorTxt = new StringBuilder();
                    TemplateUtils.loadTemplateFile(descs, errorTxt, (IPath)new Path(file.toString()));
                    if (!TextUtils.isEmpty((String)errorTxt.toString())) {
                        Activator.reporter.logError(errorTxt.toString(), (Throwable)ExceptionUtils.newMinimalStackException());
                    }
                }
                catch (Exception e) {
                    Activator.reporter.logError("Error loading template file: " + String.valueOf(file), (Throwable)e);
                }
                PerformanceManager.INSTANCE.logEnd(stopWatch);
                return descs;
            }
        });
    }
}

