/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.templates;

import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateDetector;
import com.silabs.ss.framework.project.internal.api.core.templates.TemplateUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.DescriptorUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseDetector;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.ISDKManager;
import com.silabs.ss.platform.api.sdk.core.SDK;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import com.silabs.ss.platform.api.sdk.core.SDKProtocolLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SDKProjectTemplateDetector
extends BaseDetector<ITemplateDescriptor>
implements ITemplateDetector {
    private SDKProtocolLoader<ITemplateDescriptor> sdkProtocolLoader = new SDKProtocolLoader(SDKProperties.TEMPLATES_FILES, (sdk, path, txt) -> {
        ArrayList<ITemplateDescriptor> newDescs = new ArrayList<ITemplateDescriptor>();
        TemplateUtils.loadTemplateFile(newDescs, sdk, txt, path);
        return newDescs;
    });

    public SDKProjectTemplateDetector() {
        super("Scanning templates...", ITemplateDescriptor.class);
    }

    protected void detectInDirectory(List<ITemplateDescriptor> descs, File dir) {
    }

    protected void quickScan(List<ITemplateDescriptor> descs, IProgressMonitor monitor) {
        List sdks = Stream.of(SDK.manager().findEnabledIds()).map(arg_0 -> ((ISDKManager)SDK.manager()).findDescriptor(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning SDKs for templates", (int)sdks.size());
        for (ISDKDescriptor sdk : sdks) {
            this.scanForSDKDesc(descs, (IProgressMonitor)subMonitor.newChild(1), sdk);
        }
    }

    public ITemplateDescriptor[] detectDescriptors(Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException {
        if (this.shouldScan(parameters, "parentId")) {
            ArrayList<ITemplateDescriptor> descs = new ArrayList<ITemplateDescriptor>();
            String sdkId = (String)parameters.get("parentId");
            ISDKDescriptor sdk = (ISDKDescriptor)SDK.manager().findDescriptor(sdkId);
            if (sdk != null) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scanning SDK for templates: " + sdk.getLabel()), (int)1);
                this.scanForSDKDesc(descs, (IProgressMonitor)subMonitor.newChild(1), sdk);
                return descs.toArray(new ITemplateDescriptor[descs.size()]);
            }
        }
        return (ITemplateDescriptor[])super.detectDescriptors(parameters, monitor);
    }

    protected boolean shouldScan(Map<String, Object> parameters, String key) {
        if ("parentId".equals(key)) {
            return parameters.get(key) != null;
        }
        return super.shouldScan(parameters, key);
    }

    private void scanForSDKDesc(List<ITemplateDescriptor> descs, IProgressMonitor monitor, ISDKDescriptor sdk) {
        try {
            String errorTxt = this.sdkProtocolLoader.loadForProtocols(descs, sdk, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            if (!TextUtils.isEmpty((String)errorTxt)) {
                Activator.reporter.logError(errorTxt, (Throwable)ExceptionUtils.newMinimalStackException());
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
            DescriptorUtils.handleDescriptorLoadingErrorText((String)"SDK Examples", (String)e.getMessage(), (IDescriptor[])new IDescriptor[]{sdk});
            return;
        }
    }
}

