/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import java.util.Collection;
import java.util.LinkedHashSet;

public class ExternalProjectCopiedFiles
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_COPIED_FILES = "copiedFiles";
    private Collection<ICopiedFileReference> copiedFiles = new LinkedHashSet<ICopiedFileReference>();
    private String copiedFileRefStr;

    public void setupInitials(Collection<ICopiedFileReference> references) {
        this.copiedFiles.clear();
        this.copiedFiles.addAll(references);
    }

    public void add(ICopiedFileReference reference) {
        this.copiedFiles.remove(reference);
        this.copiedFiles.add(reference);
    }

    public Collection<ICopiedFileReference> copiedFileRefs() {
        return this.copiedFiles;
    }

    @Override
    public void apply(MProject project) {
        project.getProperties().put((Object)ProjectProperties.COPIED_FILES.id(), (Object)this.copiedFileRefStr);
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String copiedFileRefs = ProjectProperties.COPIED_FILES.type().stringize(this.copiedFiles);
        handler.put(KEY_COPIED_FILES, copiedFileRefs);
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        this.copiedFileRefStr = handler.get(KEY_COPIED_FILES);
        this.copiedFiles = (Collection)ProjectProperties.COPIED_FILES.type().convert(this.copiedFileRefStr);
    }
}

