/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.eclipse.emf.ecore.EObject;

public abstract class ExternalProjectMetadataHandler<E extends EObject, T extends ExternalProjectMetadataHandler<E, T>> {
    private Map<String, String> contentMap = new TreeMap<String, String>();
    protected List<IExternalProjectMetadata<E>> handlers = new ArrayList<IExternalProjectMetadata<E>>();
    private boolean isLoaded = false;

    public ExternalProjectMetadataHandler() {
        this.loadMetadataHandlers(this.handlers);
    }

    protected abstract void loadMetadataHandlers(List<IExternalProjectMetadata<E>> var1);

    public T put(String key, String value) {
        this.contentMap.put(key, value);
        return this.getT();
    }

    public String get(String key) {
        return this.contentMap.get(key);
    }

    public void apply(E model) {
        this.load();
        this.handlers.forEach(e -> e.apply(model));
    }

    public void write() {
        this.handlers.forEach(e -> e.write(this));
        String moduleMetadata = CoreTypes.STRING_TO_STRING_MAP.stringize(this.contentMap);
        moduleMetadata = ExternalProjectMetadataHandler.compress(moduleMetadata);
        this.writeStringContent(moduleMetadata);
    }

    protected abstract void writeStringContent(String var1);

    protected abstract String getStringContent();

    public T load() {
        if (this.isLoaded) {
            return this.getT();
        }
        String mapContent = this.getDecompressedString();
        if (mapContent == null) {
            return this.getT();
        }
        this.contentMap = new TreeMap<String, String>((Map)CoreTypes.STRING_TO_STRING_MAP.convert(mapContent));
        this.handlers.forEach(e -> e.load(this));
        this.isLoaded = true;
        return this.getT();
    }

    public String getDecompressedString() {
        String mapContent = this.getStringContent();
        if (TextUtils.isEmpty((String)mapContent)) {
            return null;
        }
        return ExternalProjectMetadataHandler.decompress(mapContent);
    }

    private static String compress(String content) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DeflaterOutputStream out = new DeflaterOutputStream(bos);){
                ((OutputStream)out).write(content.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return Base64.getEncoder().encodeToString(bos.toByteArray());
        }
        catch (Throwable e) {
            Activator.reporter.logException(e);
            return "";
        }
    }

    private static String decompress(String content) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InflaterOutputStream out = new InflaterOutputStream(baos);){
                byte[] bytes = Base64.getDecoder().decode(content);
                ((OutputStream)out).write(bytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            Activator.reporter.logException(e);
        }
        return baos.toString();
    }

    private T getT() {
        return (T)this;
    }
}

