/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ExternalProjectPropertiesHandler
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_PROPERTIES = "SIMPLICITY_STUDIO_PROPERTIES";
    private Map<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
    private static final String[] STORED_PROPERTIES = new String[]{ProjectProperties.SAVED_STOCK_VARIABLES.id(), ProjectProperties.USER_SETTINGS.id()};

    public void add(IBuildConfiguration desc) {
        this.updateProperties((IDescriptor)desc.getParent());
        this.updateProperties((IDescriptor)desc);
    }

    public void add(IBuildConfigurationDescriptor desc) {
        this.updateProperties((IDescriptor)desc.getParent());
        this.updateProperties(desc);
    }

    private void updateProperties(IDescriptor desc) {
        ExternalProjectPropertiesHandler.saveProperties(desc, (prop, value) -> {
            String string = this.properties.computeIfAbsent(desc.getName(), s -> new HashMap()).put(prop, value);
        });
    }

    public static void saveProperties(IDescriptor desc, BiConsumer<String, String> handler) {
        String[] stringArray = STORED_PROPERTIES;
        int n = STORED_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (desc.getPropertyAccess().isValueNonDefault(prop)) {
                handler.accept(prop, desc.getPropertyAccess().getValueString(prop));
            }
            ++n2;
        }
    }

    @Override
    public void apply(MProject project) {
        this.properties.forEach((name, props) -> {
            MConfiguration config = project.findConfigurationByName(name);
            ((MDescriptor)(config == null ? project : config)).getProperties().putAll(props);
        });
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        Map<String, String> propRef = this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CoreTypes.STRING_TO_STRING_MAP.stringize((Object)((Map)e.getValue()))));
        String propStr = CoreTypes.STRING_TO_STRING_MAP.stringize(propRef);
        handler.put(KEY_PROPERTIES, propStr);
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String propStr = handler.get(KEY_PROPERTIES);
        Map propRef = (Map)CoreTypes.STRING_TO_STRING_MAP.convert(propStr);
        this.properties = propRef.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)CoreTypes.STRING_TO_STRING_MAP.convert((String)e.getValue()))));
    }
}

