/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.KeyedVariableLookup;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.BaseExternalSolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionConfigProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.CreateSolutionConfigOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.ResetSolutionModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetGeneralPropertyOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetNameOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPrebuildStepOperation;
import com.silabs.ss.framework.project.api.generator.template.ITemplateContribution;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGenerator;
import com.silabs.ss.framework.project.api.generator.template.TemplateContribution;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericSolutionMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTypeUtils;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericIDETemplate;
import com.silabs.ss.framework.project.internal.core.type.generic.metadata.IDEGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.NonTemplateSolutionFileContext;
import com.silabs.ss.framework.project.internal.core.type.generic.model.SubProject;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileJinjaOptions;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenericSolutionOperationHandler
extends BaseExternalSolutionEngineOperationHandler
implements ISolutionEngineOperationHandler {
    private static final int SUBPROJECT_ORDINAL = 0;
    private List<IDEGenerator> nonTemplateGeneratorList;
    private GenericTemplates allTemplates;
    private IGenericIDETemplate templates;
    private GenericSolutionMetadataHandler metadata;
    private NonTemplateSolutionFileContext solutionContext;
    private IVariableStore projectVariables = new KeyedVariableLookup();
    protected List<File> templateFiles;
    private Map<String, Object> contentMap = new HashMap<String, Object>();

    public GenericSolutionOperationHandler(ISolutionEntity solution, GenericTemplates templates, List<IDEGenerator> nonTemplateGeneratorList) {
        super(solution);
        this.allTemplates = templates;
        this.solutionContext = new NonTemplateSolutionFileContext(solution);
        this.nonTemplateGeneratorList = nonTemplateGeneratorList;
    }

    @Override
    public void load() throws CoreException {
        File outfile = this.getSolutionEntity().getSolutionPath().removeLastSegments(1).append(this.getSolutionEntity().getName() + "_cmake").append("CMakeLists.txt").toFile();
        this.metadata = GenericSolutionMetadataHandler.forWriting(this.contentMap, outfile);
        this.metadata.solution().clean();
        this.metadata.solution().model().setName(this.getSolutionEntity().getName());
    }

    @Override
    public void commit() throws CoreException {
        try {
            this.metadata.write();
            IPath installPath = this.getSolutionEntity().getSolutionPath().removeLastSegments(1);
            installPath.toFile().mkdirs();
            this.projectVariables.setValue("SOLUTION_NAME", (Object)this.solutionContext.getSolutionName());
            this.templates = (IGenericIDETemplate)this.allTemplates.getIDETemplate((IDescriptor)this.getSolutionEntity());
            this.templateFiles = this.allTemplates.getTemplates(this.getSolutionEntity(), this.templates);
            ITemplateGenerator generator = this.createGenerator();
            Map<String, Object> projectContentMap = this.getContentMap();
            this.populateGeneratorWithContent(generator, projectContentMap);
            this.generateOutputFromTemplateFiles(generator, installPath);
            GenericTypeUtils.generateOutputWithGenerators(this.nonTemplateGeneratorList, this.solutionContext);
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
            throw Activator.reporter.newCoreException("Failed to generate solution related configuration files!", (Throwable)e);
        }
    }

    private Map<String, Object> getContentMap() {
        MakefileJinjaOptions.setupToolsInfoData(null, this.contentMap);
        this.setupSubProjectInfo(this.contentMap);
        this.contentMap.put("SOLUTION_NAME", this.solutionContext.getSolutionName());
        this.contentMap.put("SUB_PROJECT_LIST", this.solutionContext.getSubProjectList());
        this.contentMap.put("PROJECT_NAME_LIST", this.solutionContext.getSubProjectList().stream().map(SubProject::getProjectName).toList());
        this.contentMap.put(MakefileJinjaOptions.PostBuildToolOpts.POST_BUILD_ARGS.name(), this.solutionContext.getPostBuild());
        this.contentMap.put(MakefileJinjaOptions.PostBuildToolOpts.PRE_BUILD_ARGS.name(), this.solutionContext.getPreBuild());
        return this.contentMap;
    }

    private void setupSubProjectInfo(Map<String, Object> projectContentMap) {
        SubProject subproject = this.solutionContext.getSubProjectList().get(0);
        this.contentMap.put("MAIN_SUB_PROJECT_NAME", subproject.getProjectName());
        String subProjectLocation = Paths.get(subproject.getLocation(), new String[0]).normalize().toString().trim();
        StringBuilder pathBuilder = new StringBuilder("${sourceDir}").append("/../");
        if (!subProjectLocation.isBlank()) {
            subProjectLocation = subProjectLocation.replace(File.separator, "/");
            pathBuilder.append(subProjectLocation).append("/");
        }
        this.contentMap.put("MAIN_SUB_PROJECT_FOLDER", pathBuilder.toString());
    }

    private void populateGeneratorWithContent(ITemplateGenerator generator, Map<String, Object> projectContentMap) {
        projectContentMap.forEach((key, value) -> generator.add((ITemplateContribution)new TemplateContribution(key, value, 1)));
    }

    private void generateOutputFromTemplateFiles(ITemplateGenerator generator, IPath basePath) throws IOException {
        for (File template : this.templateFiles) {
            File outputFile = this.getNewFile(basePath, template, generator);
            GenericTypeUtils.generateOutputFromTemplateFiles(this.templates, template, generator, outputFile);
        }
    }

    private File getNewFile(IPath basePath, File templateFile, ITemplateGenerator generator) {
        File file = Optional.ofNullable(this.allTemplates).flatMap(t -> t.getTargetPath(templateFile, (IVariableLookup)this.projectVariables)).map(path -> new File(basePath.toFile(), (String)path)).orElse(null);
        if (file != null) {
            return file;
        }
        return null;
    }

    private ITemplateGenerator createGenerator() throws CoreException {
        return GenericTypeUtils.createGenerator(this.templateFiles);
    }

    @Override
    public void handleSetSolutionConfigPrebuildStepOperation(SetSolutionConfigPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.solutionContext.setPreBuild(this.substitutePostBuildVariables(operation.buildStep()));
    }

    @Override
    public void handleSetSolutionConfigPostbuildStepOperation(SetSolutionConfigPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.solutionContext.setPostBuild(this.substitutePostBuildVariables(operation.buildStep()));
    }

    @Override
    public void handleAddSolutionModuleReferenceOperation(AddSolutionModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionModuleReference ref = SolutionModelFactory.eINSTANCE.createMSolutionModuleReference();
        ref.setId(operation.moduleId());
        this.metadata.solution().model().getSolutionModuleReferences().add((Object)ref);
    }

    @Override
    public void handleAddSolutionDefinedModuleOperation(AddSolutionDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.solution().model().getSolutionDefinedModules().add((Object)operation.module());
    }

    @Override
    public void handleCreateSolutionConfigOperation(CreateSolutionConfigOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleSetGeneralPropertyOperation(SetGeneralPropertyOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public String lookupCommanderVariable() {
        return "$(POST_BUILD_EXE)";
    }

    @Override
    public void handleSetNameOperation(SetNameOperation operation, IProgressMonitor monitor) throws CoreException {
        String solutionName = operation.getSession().getSolutionDescriptor().getId();
        this.solutionContext.setSolutionName(solutionName);
        this.metadata.solution().model().setName(operation.name());
    }

    @Override
    public void handleAddProjectOperation(AddSolutionProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        SubProject subProject = new SubProject(operation.projectName(), operation.location());
        this.solutionContext.addProject(subProject);
    }

    @Override
    public void handleAddSolutionConfigProjectOperation(AddSolutionConfigProjectOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleResetSolutionModuleReferencesOperation(ResetSolutionModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
    }
}

