/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.google.common.collect.ListMultimap;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARDirectOptionsMapping;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARGenericOptionsMappings;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarIpcfModelUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwpModelUtils;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IARExternalProjectImporter
extends BaseExternalProjectImporter
implements IExternalImporter {
    public static final String LINKERARM = "ILINK";
    public static final String ASSEMBLERARM = "AARM";
    public static final String COMPILERARM = "ICCARM";
    public static final String LINKER8051 = "XLINK";
    public static final String ASSEMBLER8051 = "A8051";
    public static final String COMPILER8051 = "ICC8051";
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$.*?\\$");

    public IARExternalProjectImporter(String superTypeId) {
        super(superTypeId);
    }

    @Override
    public ImportProjectRecord[] findProjects(File projectLocation) {
        File file;
        int n;
        int n2;
        File[] fileArray;
        HashSet<ImportProjectRecord> projectRecordsList = new HashSet<ImportProjectRecord>();
        File[] ewpFiles = projectLocation.listFiles((dir, name) -> "ewp".equals(FileUtils.getExtension((String)name)));
        File[] ewwFiles = projectLocation.listFiles((dir, name) -> "eww".equals(FileUtils.getExtension((String)name)));
        if (ewwFiles != null) {
            fileArray = ewwFiles;
            n2 = ewwFiles.length;
            n = 0;
            while (n < n2) {
                block10: {
                    file = fileArray[n];
                    if (!file.isFile()) {
                        Activator.reporter.logError("File not found " + String.valueOf(file));
                    } else {
                        Element root;
                        try {
                            root = IarEwProjectUtils.loadXml(file);
                        }
                        catch (CoreException e) {
                            Activator.reporter.logError("Could not parse file", (Throwable)e);
                            break block10;
                        }
                        ListMultimap<String, Node> childNodes = IarEwpModelUtils.getChildNodes(root);
                        for (Node projectNode : childNodes.get((Object)"project")) {
                            ListMultimap<String, Node> projectChildNodes = IarEwpModelUtils.getChildNodes(projectNode);
                            for (Node pathNode : projectChildNodes.get((Object)"path")) {
                                IPath projectPath = IPathUtils.createPossiblyRelativePath((String)pathNode.getTextContent().replaceAll("\\$WS_DIR\\$", projectLocation.toString().replaceAll("\\\\", "\\\\\\\\")));
                                projectRecordsList.add(new ImportProjectRecord(projectPath.removeFileExtension().lastSegment(), projectPath.toFile()));
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (ewpFiles != null) {
            fileArray = ewpFiles;
            n2 = ewpFiles.length;
            n = 0;
            while (n < n2) {
                file = fileArray[n];
                projectRecordsList.add(new ImportProjectRecord(new Path(file.getName()).removeFileExtension().lastSegment(), file));
                ++n;
            }
        }
        return projectRecordsList.toArray(new ImportProjectRecord[projectRecordsList.size()]);
    }

    @Override
    public MProject createImportModel(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        File projectFile = importDescr.getInputLocation();
        if (!projectFile.isFile()) {
            MProject mproject = ProjectModelFactory.eINSTANCE.createMProject();
            mproject.setContentRoot(importDescr.getInputLocation().getParentFile().toURI().toString());
            return mproject;
        }
        IARProject iarProject = IarEwProjectUtils.loadIarProject(projectFile);
        iarProject.formatForImport();
        importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)IARDirectOptionsMapping.registry());
        importDescr.getOptionMappingRegistries().add((IOptionMappingRegistry<?, ?, ?>)IARGenericOptionsMappings.iarOptionMappingRegistry);
        BaseExternalProjectImporter.ExternalProject extProj = this.externalProjectToMProject(iarProject, importDescr);
        MProject mproject = IarIpcfModelUtils.cleanMProjectFromIpcf(extProj, iarProject);
        StringBuilder partSb = new StringBuilder();
        for (IARConfiguration config : iarProject.getConfigurations()) {
            ImporterTool.ToolchainID toolchain;
            String partName = config.getPart().getPartName();
            if (partName != null) {
                IPartDescriptor[] parts = (IPartDescriptor[])Part.manager().findDescriptorsFromName(partName);
                String partCompat = Stream.of(parts).filter(Objects::nonNull).map(IDescribable::getId).collect(Collectors.joining(" "));
                partSb.append(partCompat).append(" ");
            }
            if ((toolchain = config.getToolchain()) == ImporterTool.ToolchainID.ARM) {
                partSb.append("mcu.arm.*").append(' ');
                continue;
            }
            if (toolchain != ImporterTool.ToolchainID.EIGHTYFIFTYONE) continue;
            partSb.append("mcu.8051.*").append(' ');
        }
        mproject.setPartCompatibility(partSb.toString().trim());
        Collection unconvertedVariables = iarProject.getConfigurations().stream().map(IARConfiguration::getUnconvertedVariables).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!unconvertedVariables.isEmpty()) {
            importDescr.getReport().addMessage(2, "The following IAR toolchain variables were detected but are not currently supported: " + TextUtils.catenateStrings((Collection)unconvertedVariables, (String)", "));
        }
        return mproject;
    }

    @Override
    public IStatus getImportMessage(ImportMode mode) {
        if (mode == ImportMode.COPY) {
            return Activator.reporter.newWarningStatus("Copying files from IAR projects may prevent the imported project from building correctly. Linking or in-place is preferred.", null);
        }
        return super.getImportMessage(mode);
    }

    @Override
    public MSolution createImportSolutionModel(IImportSolutionDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        File solutionFile = importDescr.getInputLocation();
        MSolution defaultMSln = SolutionModelFactory.eINSTANCE.createMSolution();
        if (!solutionFile.isFile()) {
            return defaultMSln;
        }
        IarProjectConnectionType slnIwcf = IarEwProjectUtils.getSlnIwcf(solutionFile.toPath());
        if (slnIwcf == null) {
            return defaultMSln;
        }
        IarEwwMetadataHandler slnMetadata = (IarEwwMetadataHandler)new IarEwwMetadataHandler(slnIwcf).load();
        MSolution slnModel = slnMetadata.solution().model();
        return slnModel;
    }
}

