/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectBuiltinController;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectCopiedFiles;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectModuleHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPathVariablesController;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPropertiesHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpBuiltinController;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpDefaultsController;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.StudioMetadata;
import java.util.List;

public class IarEwpMetadataHandler
extends ExternalProjectMetadataHandler<MProject, IarEwpMetadataHandler> {
    private ExternalProjectModuleHandler modules;
    private ExternalProjectCopiedFiles copiedFiles;
    private ExternalProjectPropertiesHandler properties;
    private ExternalProjectPathVariablesController variables;
    private IarEwpBuiltinController builtins;
    private IarEwpDefaultsController defaults;
    private IarProjectConnectionType ipcf;

    public static IarEwpMetadataHandler load(IarProjectConnectionType loadFrom, IarProjectConnectionType writeTo) {
        return ((IarEwpMetadataHandler)new IarEwpMetadataHandler(loadFrom).load()).updateIpcf(writeTo);
    }

    public IarEwpMetadataHandler(IarProjectConnectionType ipcf) {
        this.ipcf = ipcf;
    }

    public ExternalProjectModuleHandler modules() {
        return this.modules;
    }

    public ExternalProjectCopiedFiles copiedFiles() {
        return this.copiedFiles;
    }

    public ExternalProjectPropertiesHandler properties() {
        return this.properties;
    }

    public ExternalProjectPathVariablesController variables() {
        return this.variables;
    }

    public ExternalProjectBuiltinController builtins() {
        return this.builtins;
    }

    public IarEwpDefaultsController defaults() {
        return this.defaults;
    }

    private IarEwpMetadataHandler updateIpcf(IarProjectConnectionType ipcf) {
        this.ipcf = ipcf;
        return this;
    }

    @Override
    protected void loadMetadataHandlers(List<IExternalProjectMetadata<MProject>> handlers) {
        this.modules = new ExternalProjectModuleHandler();
        this.copiedFiles = new ExternalProjectCopiedFiles();
        this.properties = new ExternalProjectPropertiesHandler();
        this.variables = new ExternalProjectPathVariablesController();
        this.defaults = new IarEwpDefaultsController();
        this.builtins = new IarEwpBuiltinController();
        handlers.add(this.modules);
        handlers.add(this.copiedFiles);
        handlers.add(this.properties);
        handlers.add(this.variables);
        handlers.add(this.defaults);
        handlers.add(this.builtins);
    }

    @Override
    protected void writeStringContent(String metadata) {
        IarEwpMetadataHandler.getMetadata(this.ipcf).setMetadata(metadata);
    }

    @Override
    protected String getStringContent() {
        StudioMetadata metadata = IarEwpMetadataHandler.getMetadata(this.ipcf);
        if (TextUtils.isEmpty((String)metadata.getMetadata())) {
            return "";
        }
        return metadata.getMetadata();
    }

    private static StudioMetadata getMetadata(IarProjectConnectionType ipcf) {
        if (ipcf == null) {
            return IarProjectConnectionFactory.eINSTANCE.createStudioMetadata();
        }
        StudioMetadata metadata = ipcf.getStudioMetadata();
        if (metadata == null) {
            metadata = IarProjectConnectionFactory.eINSTANCE.createStudioMetadata();
            ipcf.setStudioMetadata(metadata);
        }
        ipcf.setStudioMetadata(metadata);
        return metadata;
    }
}

