/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelSwitchRecurser;
import com.silabs.ss.framework.project.api.core.utils.ProjectFileUtils;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.FilePathType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.FilesType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.GroupType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.Groupable;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.util.manual.IarProjectConnectionSwitchRecurser;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARContentContainer;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAREntry;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARFile;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARGroup;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;

public final class IarIpcfModelUtils {
    public static final String STUDIO_IPCF_NAME = "Simplicity Configurator";

    public static IarProjectConnectionType createStudioIpcf() {
        IarProjectConnectionType ipcf = IarProjectConnectionFactory.eINSTANCE.createIarProjectConnectionType();
        ipcf.setVersion("1.8");
        ipcf.setName(STUDIO_IPCF_NAME);
        return ipcf;
    }

    public static Groupable findOrCreateFolder(Groupable parent, IPath dirPath) {
        return IarIpcfModelUtils.doFindOrCreateFolder(parent, dirPath, true);
    }

    public static Groupable findFolder(Groupable parent, IPath dirPath) {
        return IarIpcfModelUtils.doFindOrCreateFolder(parent, dirPath, false);
    }

    private static Groupable doFindOrCreateFolder(Groupable parent, IPath dirPath, boolean create) {
        Groupable group = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            String dirName = dirPath.segment(i);
            group = IarIpcfModelUtils.findFolder(parent, dirName);
            if (group == null) {
                if (!create) {
                    return null;
                }
                GroupType groupType = IarProjectConnectionFactory.eINSTANCE.createGroupType();
                group = groupType;
                groupType.setName(dirName);
                parent.getGroups().add((Object)groupType);
            }
            parent = group;
            ++i;
        }
        return group;
    }

    private static GroupType findFolder(Groupable parent, String folderName) {
        if (parent == null) {
            return null;
        }
        for (GroupType folder : parent.getGroups()) {
            if (!folderName.equalsIgnoreCase(folder.getName())) continue;
            return folder;
        }
        return null;
    }

    public static IARFile findOrCreateFile(IARContentContainer parent, IPath dirPath, String fileLoc) {
        return IarIpcfModelUtils.doFindOrCreateFile(parent, dirPath, fileLoc, true);
    }

    public static IARFile findFile(IARContentContainer parent, IPath dirPath, String fileLoc) {
        return IarIpcfModelUtils.doFindOrCreateFile(parent, dirPath, fileLoc, false);
    }

    public static IARFile doFindOrCreateFile(IARContentContainer parent, IPath dirPath, String fileLoc, boolean create) {
        IARContentContainer container = IarIpcfModelUtils.doFindOrCreateFolder(parent, dirPath.removeLastSegments(1), create);
        if (container == null) {
            return null;
        }
        IARFile file = container.getChildFiles().stream().filter(f -> Objects.equals(fileLoc, f.getName()) || Objects.equals(fileLoc, f.getNodeName()) || Objects.equals(new File(fileLoc), f.file())).findAny().orElse(null);
        if (file == null && create) {
            file = container.addFile(fileLoc);
        }
        return file;
    }

    public static IARContentContainer findOrCreateFolder(IARContentContainer parent, IPath dirPath) {
        return IarIpcfModelUtils.doFindOrCreateFolder(parent, dirPath, true);
    }

    public static IARContentContainer findFolder(IARContentContainer parent, IPath dirPath) {
        return IarIpcfModelUtils.doFindOrCreateFolder(parent, dirPath, false);
    }

    private static IARContentContainer doFindOrCreateFolder(IARContentContainer parent, IPath dirPath, boolean create) {
        IARContentContainer group = parent;
        int i = 0;
        while (i < dirPath.segmentCount()) {
            String dirName = dirPath.segment(i);
            group = IarIpcfModelUtils.findFolder(parent, dirName);
            if (group == null) {
                if (!create) {
                    return null;
                }
                group = parent.addGroup(dirName);
            }
            parent = group;
            ++i;
        }
        return group;
    }

    private static IARContentContainer findFolder(IARContentContainer parent, String folderName) {
        if (parent == null) {
            return null;
        }
        for (IARGroup folder : parent.getChildFolders()) {
            if (!folderName.equalsIgnoreCase(folder.getName())) continue;
            return folder;
        }
        return null;
    }

    public static IPath getPathFor(FilePathType file) {
        String fileName = IPathUtils.createPath((String)file.getPath()).lastSegment();
        if (file.eContainer() instanceof Groupable) {
            return IarIpcfModelUtils.getPathFor((Groupable)file.eContainer()).append(fileName);
        }
        return IPathUtils.createPath((String)fileName);
    }

    public static IPath getPathFor(Groupable folder) {
        IPath parentPath = IPathUtils.createPath((String)"");
        if (folder instanceof FilesType || folder == null) {
            return parentPath;
        }
        if (folder.eContainer() instanceof Groupable) {
            parentPath = IarIpcfModelUtils.getPathFor((Groupable)folder.eContainer());
        }
        if (folder instanceof GroupType) {
            return parentPath.append(((GroupType)folder).getName());
        }
        return parentPath;
    }

    public static MProject cleanMProjectFromIpcf(BaseExternalProjectImporter.ExternalProject extProj, IARProject iarproj) {
        MProject mproject = extProj.getMProject();
        Optional<IarProjectConnectionType> ipcfType = IarIpcfModelUtils.findIpcfFiles(iarproj);
        ipcfType.map(IarEwpMetadataHandler::new).ifPresent(h -> h.apply(mproject));
        ipcfType.ifPresent(t -> IarIpcfModelUtils.registerIpcfFiles(t, mproject));
        for (IARConfiguration iarConfig : iarproj.getConfigurations()) {
            MConfiguration mconfig = mproject.findConfigurationByName(iarConfig.getName());
            if (mconfig == null) {
                throw new IllegalStateException("Failed to find Configuration for " + iarConfig.getName());
            }
            mconfig.setPrebuildStep(iarConfig.buildActions().preBuild());
            mconfig.setPostbuildStep(iarConfig.buildActions().postBuild());
        }
        ipcfType.ifPresent(t -> {
            if (t.getPreBuild() != null) {
                mproject.setPrebuildStep(t.getPreBuild().getCommand());
            }
            if (t.getPostBuild() != null) {
                mproject.setPostbuildStep(t.getPostBuild().getCommand());
            }
        });
        boolean ipcfFileRemoved = mproject.getFiles().removeIf(f -> f.getName().endsWith(".ipcf"));
        MFolderEntry ipcfFolder = ProjectModelUtils.findFolder(null, (MFolderEntry)mproject, STUDIO_IPCF_NAME);
        if (ipcfFolder == null) {
            return mproject;
        }
        if (ipcfType.isPresent() && ipcfFileRemoved) {
            mproject.getFolders().remove((Object)ipcfFolder);
            MConfiguration config = ProjectModelFactory.eINSTANCE.createMConfiguration();
            extProj.convertedLibraries().entrySet().stream().filter(e -> STUDIO_IPCF_NAME.equals(ProjectModelUtils.getProjectPathFor((MEntry)e.getKey()).segment(0))).map(Map.Entry::getValue).forEachOrdered(arg_0 -> config.getLibraryFiles().add(arg_0));
        } else {
            new ProjectModelSwitchRecurser<Object>(){

                public Object caseMEntry(MEntry entry) {
                    entry.setBuiltin(true);
                    return null;
                }
            }.doSwitch((EObject)ipcfFolder);
            mproject.getFiles().addAll((Collection)ipcfFolder.getFiles());
            mproject.getFolders().addAll((Collection)ipcfFolder.getFolders());
            mproject.getFolders().remove((Object)ipcfFolder);
        }
        new ProjectModelSwitchRecurser<Object>(){

            public Object caseMConfigSettings(MConfigSettings settings) {
                ArrayList<String> newExclusions = new ArrayList<String>();
                for (String path : settings.getExcludedPaths()) {
                    int idx = path.indexOf("Simplicity Configurator/");
                    if (idx >= 0) {
                        path = path.substring(idx + IarIpcfModelUtils.STUDIO_IPCF_NAME.length() + 1);
                    }
                    newExclusions.add(path);
                }
                settings.getExcludedPaths().clear();
                settings.getExcludedPaths().addAll(newExclusions);
                return null;
            }
        }.doSwitch((EObject)mproject);
        return mproject;
    }

    private static void registerIpcfFiles(IarProjectConnectionType ipcf, final MProject project) {
        final Path basePath = ipcf.loadedFile() == null ? new File("").toPath() : ipcf.loadedFile().getParentFile().toPath();
        new IarProjectConnectionSwitchRecurser<Object>(){

            @Override
            public Object caseGroupType(GroupType group) {
                ProjectModelUtils.findOrCreateFolder(null, (MFolderEntry)project, IarIpcfModelUtils.getPathFor(group));
                return null;
            }

            @Override
            public Object caseFilePathType(FilePathType file) {
                Path path = basePath.resolve(file.getPath().replace("\\", "/"));
                String filePath = IPathUtils.createPath((String)path.toString()).toFile().toURI().toString();
                MFileContent mFile = ProjectModelUtils.findOrCreateFileContent(null, project, IarIpcfModelUtils.getPathFor(file), filePath);
                mFile.setBuiltin(true);
                mFile.setLinked(Boolean.valueOf(true));
                if (ProjectFileUtils.isLibraryFile(path.toFile())) {
                    ((ProjectModelObjFactory.CreateMLibraryFile)ProjectModelObjFactory.forMLibraryFile().setUri(filePath).set(l -> l.setBuiltin(true))).apply((MSettingsSite)project);
                }
                return null;
            }
        }.doSwitch(ipcf);
    }

    public static Optional<IarProjectConnectionType> findIpcfFiles(IARProject project) {
        return project.getChildFiles().stream().filter(file -> file.getName().endsWith(".ipcf")).map(IAREntry::file).map(IarEwProjectUtils::loadProjectConnection).filter(Objects::nonNull).filter(p -> STUDIO_IPCF_NAME.equals(p.getName())).findAny();
    }
}

