/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.google.common.collect.ImmutableList;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.iarew.IIarEwpCCAllowListOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpArmExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.CCAllowListSubOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringOption;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Node;

public class CCAllowListOption
extends StringOption {
    private ImporterTool.ToolchainID toolchain;
    private ImmutableList<CCAllowListSubOption> subOptions;

    public static Collection<? extends BaseIAROption<?>> options(Node optionNode, ImporterTool.ToolchainID toolchainID) {
        List<CCAllowListSubOption> subOptions = new CCAllowListOption(optionNode, toolchainID).subOptions();
        return subOptions;
    }

    public static boolean isApplicable(String optionName) {
        return "CCAllowList".equals(optionName);
    }

    private CCAllowListOption(Node optionNode, ImporterTool.ToolchainID toolchain) {
        super(optionNode);
        this.toolchain = toolchain;
        this.subOptions = this.handleCCAllowList(optionNode, this.toolchain);
    }

    public List<CCAllowListSubOption> subOptions() {
        return this.subOptions;
    }

    public void updateValue() {
        StringBuilder sb = new StringBuilder();
        for (CCAllowListSubOption subOpt : this.subOptions) {
            sb.append(subOpt.serializedValue());
        }
        this.setValue(sb.toString());
    }

    private ImmutableList<CCAllowListSubOption> handleCCAllowList(Node optionNode, ImporterTool.ToolchainID toolchainID) {
        StringOption option = new StringOption(optionNode);
        IIarEwpCCAllowListOptions[] newOptionNames = this.getOptionNames(toolchainID, option);
        if (newOptionNames == null) {
            return ImmutableList.of();
        }
        return this.optionStateToOptionList(option, optionNode, newOptionNames);
    }

    private IIarEwpCCAllowListOptions[] getOptionNames(ImporterTool.ToolchainID toolchainID, StringOption option) {
        if (toolchainID == ImporterTool.ToolchainID.ARM && option.getVersion().equals("1")) {
            return IarEwpArmExternalOptions.CCAllowList.values();
        }
        if (toolchainID == ImporterTool.ToolchainID.EIGHTYFIFTYONE && option.getVersion().equals("1")) {
            return IarEwpArmExternalOptions.CCAllowList.values();
        }
        Activator.reporter.logWarning("Unknown toolchain type or option version for " + option.getName() + " Verion: " + option.getVersion() + " Toolchain: " + String.valueOf((Object)toolchainID));
        return null;
    }

    private ImmutableList<CCAllowListSubOption> optionStateToOptionList(StringOption option, Node optionNode, IIarEwpCCAllowListOptions[] options) {
        String state = option.getValue();
        if (options.length < state.length()) {
            return this.error(option, "Option names array does not equal option state list length.");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (i < state.length()) {
            builder.add((Object)new CCAllowListSubOption(this, options[i].name(), state.charAt(i)));
            ++i;
        }
        return builder.build();
    }

    private ImmutableList<CCAllowListSubOption> error(BaseIAROption<?> option, String errorTxt) {
        Activator.reporter.logInfo("Option string has unknown mapping: " + option.getName() + ". IAR EW 6.7 projects supported - Ignoring option.\n" + errorTxt);
        return ImmutableList.of();
    }
}

