/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import org.w3c.dom.Element;

public final class IARBuildActions {
    private static final String NODE_NAME_PRE_BUILD = "prebuild";
    private static final String NODE_NAME_POST_BUILD = "postbuild";
    private final IARElement preBuild;
    private final IARElement postBuild;

    public IARBuildActions(IARConfiguration parent, IARElement element) {
        IARElement dataNode = this.findData(element, "data");
        this.preBuild = this.findData(dataNode, NODE_NAME_PRE_BUILD);
        this.postBuild = this.findData(dataNode, NODE_NAME_POST_BUILD);
    }

    private IARElement findData(IARElement element, String name) {
        return element.childNodes().get((Object)name).stream().map(IARElement::new).findFirst().orElseGet(() -> this.createNew(element, name));
    }

    private IARElement createNew(IARElement element, String name) {
        Element newNode = element.getNode().getOwnerDocument().createElement(name);
        element.getNode().appendChild(newNode);
        return new IARElement(newNode);
    }

    public String postBuild() {
        return this.postBuild.getNode().getTextContent();
    }

    public void setPostBuild(String content) {
        this.postBuild.getNode().setTextContent(content);
    }

    public String preBuild() {
        return this.preBuild.getNode().getTextContent();
    }

    public void setPreBuild(String content) {
        this.preBuild.getNode().setTextContent(content);
    }
}

