/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringOption;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class IARChipSelect {
    private static final String NODE_NAME_CHIP = "OGChipSelectEditMenu";
    private static final String NODE_NAME_GFPU = "GFPUDeviceSlave";
    private static final String CONSTANT_NAME = "\tSiliconLaboratories ";
    private final IARConfiguration parent;
    private StringOption chipOption;
    private StringOption gfpuOption;
    private String partName;

    public IARChipSelect(IARConfiguration parent) {
        this.parent = parent;
        this.chipOption = (StringOption)this.parent.findOption(NODE_NAME_CHIP);
        this.gfpuOption = (StringOption)this.parent.findOption(NODE_NAME_GFPU);
        this.partName = Optional.ofNullable(this.chipOption).map(StringOption::getValue).map(s -> s.split("\\s+")[0]).orElse("");
    }

    public String getPartName() {
        return this.partName;
    }

    public void changePart(String partId, String partOpn) {
        String opn = partOpn;
        IPartDescriptor partDesc = (IPartDescriptor)Part.manager().findDescriptor(partId);
        if (partDesc != null && !"com.silabs.part.none".equals(partDesc.getId())) {
            opn = partDesc.getName();
        }
        if (opn != null) {
            this.changePart(opn.toUpperCase(Locale.ROOT));
        }
    }

    private void changePart(String partOpn) {
        if (partOpn == null || Objects.equals(this.partName, partOpn)) {
            return;
        }
        this.partName = partOpn;
        String stateValue = this.partName + CONSTANT_NAME + this.partName;
        this.chipOption.setValue(stateValue);
        this.gfpuOption.setValue(stateValue);
    }

    public static boolean isManaged(String optionName) {
        return NODE_NAME_CHIP.equals(optionName) || NODE_NAME_GFPU.equals(optionName);
    }
}

