/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIListOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IARLibraries {
    private final StringListOption option;
    private IARConfiguration parent;

    public IARLibraries(IARConfiguration parent) {
        this.parent = parent;
        this.option = (StringListOption)parent.getAndClear(parent.configInfo.getLinkerLibrariesOptionName());
    }

    public void addLibrary(String name, boolean replace) {
        if (TextUtils.isEmpty((String)name)) {
            return;
        }
        this.option.appendState(name, replace);
    }

    public List<MBuildSetting> convert() {
        ArrayList<MLibraryPath> convertedContents = new ArrayList<MLibraryPath>(this.optionToMLibraryPathList(this.option));
        return convertedContents;
    }

    private List<MLibraryPath> optionToMLibraryPathList(BaseIAROption<?> libraryPathOption) {
        if (libraryPathOption == null) {
            return Collections.emptyList();
        }
        ArrayList<MLibraryPath> libraryPaths = new ArrayList<MLibraryPath>();
        assert (libraryPathOption instanceof URIListOption || libraryPathOption instanceof StringListOption);
        for (String rawPath : libraryPathOption.getStateList()) {
            if (rawPath.contains("$TOOLKIT_DIR$")) {
                this.parent.getUnconvertedVariables().add("$TOOLKIT_DIR$");
                continue;
            }
            MLibraryPath mLibraryPath = ProjectImportUtils.createMLibraryPathFromString(rawPath, this.parent.projectFolder().toFile().toURI(), this.parent.variableReplacements, IARExternalProjectImporter.VARIABLE_PATTERN, this.parent.getUnconvertedVariables());
            libraryPaths.add(mLibraryPath);
        }
        return libraryPaths;
    }
}

