/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import java.util.Locale;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IarEwpModelUtils {
    private IarEwpModelUtils() {
    }

    public static ListMultimap<String, Node> getChildNodes(Node element) {
        NodeList children = element.getChildNodes();
        ArrayListMultimap childContents = ArrayListMultimap.create();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String childNodeName = child.getNodeName();
            childContents.put((Object)childNodeName, (Object)child);
            ++i;
        }
        return childContents;
    }

    public static ImporterTool.ToolchainID getToolchainID(String toolchain) {
        String key = toolchain.toLowerCase(Locale.ROOT);
        if (key.equals("arm")) {
            return ImporterTool.ToolchainID.ARM;
        }
        if (key.equals("8051")) {
            return ImporterTool.ToolchainID.EIGHTYFIFTYONE;
        }
        return ImporterTool.ToolchainID.ARM;
    }
}

