/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwBatchDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Node;

public class IarEwwBatchBuild
extends IARElement {
    protected static final String ELEMENT_BATCHDEF = "batchDefinition";
    protected static final String ELEMENT_NAME = "name";
    private List<IarEwwBatchDefinition> batchDefinitions = new ArrayList<IarEwwBatchDefinition>();

    IarEwwBatchBuild(Node node) {
        super(node);
        this.loadBatchDefinitions();
    }

    public List<IarEwwBatchDefinition> batchDefinitions() {
        return this.batchDefinitions;
    }

    protected void loadBatchDefinitions() {
        for (Node groupNode : this.childNodes().get((Object)ELEMENT_BATCHDEF)) {
            this.batchDefinitions.add(new IarEwwBatchDefinition(groupNode));
        }
    }

    public IarEwwBatchDefinition addBatchDefinition(String batchDefName, List<IarEwwBatchEntry> entries) {
        Node batchDefNode = this.createSubNode(batchDefName, ELEMENT_BATCHDEF, ELEMENT_NAME);
        IarEwwBatchDefinition newBatchDef = new IarEwwBatchDefinition(batchDefNode);
        for (IarEwwBatchEntry entry : entries) {
            newBatchDef.addMember(entry.projName, entry.configName);
        }
        this.batchDefinitions.add(newBatchDef);
        return newBatchDef;
    }

    public boolean removeBatchDefinitionsWithName(String batchDefName) {
        List<IarEwwBatchDefinition> batchDefsToRemove = this.batchDefinitions.stream().filter(batchDef -> Objects.equals(batchDef.getName(), batchDefName)).toList();
        for (IarEwwBatchDefinition batchDef2 : batchDefsToRemove) {
            if (this.getNode().removeChild(batchDef2.getNode()) == null) {
                return false;
            }
            this.batchDefinitions.remove(batchDef2);
        }
        return true;
    }

    public record IarEwwBatchEntry(String projName, String configName) {
    }
}

