/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class URIListOption
extends BaseIAROption<Collection<URI>> {
    public URIListOption(Node optionNode, IPath projectFolder) {
        super(optionNode);
    }

    @Override
    public List<URI> getValue() {
        List<URI> uriList = ProjectImportUtils.convertStringListToURIList(this.getStateList());
        return uriList;
    }

    @Override
    protected Collection<String> convertToStringList(Object value) {
        return URIListOption.convertUriListToStringList(value);
    }

    static Collection<String> convertUriListToStringList(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(URIListOption::convert).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (value == null || "".equals(value)) {
            return Arrays.asList(new String[0]);
        }
        if (value instanceof URI) {
            return List.of(URIListOption.convert(value));
        }
        return Arrays.asList(String.valueOf(value));
    }

    private static String convert(Object obj) {
        String valueStr;
        if (obj instanceof String) {
            valueStr = (String)obj;
        } else if (obj instanceof URI) {
            try {
                valueStr = URIUtils.resolveURIPath((URI)((URI)obj));
            }
            catch (IOException iOException) {
                valueStr = CoreTypes.URI.stringize((Object)((URI)obj));
            }
        } else {
            return null;
        }
        return valueStr.replace("%20", " ").replace("file:", "");
    }
}

