/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.silabs.java.utils.HostUtils;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.ToolInfoRequest;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.model.ToolInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class MakefileJinjaOptions {
    private static final String TOOL_INFO_COMMANDER = "commander";
    private static final String TOOL_INFO_MAKE = "make";
    private static final String TOOL_INFO_CMAKE = "cmake";
    private static final String TOOL_INFO_NINJA = "ninja";

    private MakefileJinjaOptions() {
    }

    public static Stream<DefaultSupplier> allProjectOptions() {
        return Stream.of(ProjectOptions.values(), PostBuildToolOpts.values(), PostBuildExeOpts.values(), ToolchainOpts.values(), MakeOpts.values(), NinjaOpts.values()).flatMap(enumArray -> Stream.of(enumArray));
    }

    public static Stream<DefaultSupplier> allSolutionOptions() {
        return Stream.of(SolutionOptions.values(), PostBuildToolOpts.values(), PostBuildExeOpts.values()).flatMap(enumArray -> Stream.of(enumArray));
    }

    private static boolean True() {
        return true;
    }

    public static void setupToolsInfoData(IProjectEntity entity, Map<String, Object> contentMap) {
        Map<String, MakeOpts[]> resolverList = Map.of(TOOL_INFO_COMMANDER, PostBuildExeOpts.values(), TOOL_INFO_CMAKE, CMakeOpts.values(), TOOL_INFO_NINJA, NinjaOpts.values(), TOOL_INFO_MAKE, MakeOpts.values());
        for (Map.Entry<String, MakeOpts[]> entry : resolverList.entrySet()) {
            ToolInfo info = new ToolInfoRequest(entry.getKey()).loadInfo();
            if (info.isEmpty()) continue;
            MakefileJinjaOptions.setupFilteredOption((Enum[])entry.getValue(), (String)info.path(), contentMap);
        }
        IToolchainDescriptor toolchain = StudioExporterUtils.findToolchain(entity);
        try {
            if (toolchain != null) {
                MakefileJinjaOptions.setupFilteredOption((Enum[])ToolchainOpts.values(), (String)toolchain.getInstallationPath().toString(), contentMap);
            }
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
    }

    private static <T extends Enum<?>> void setupFilteredOption(T[] options, String value, Map<String, Object> contentMap) {
        Stream.of(options).filter(opt -> ((FilteredOption)((Object)opt)).filter().getAsBoolean()).forEachOrdered(tc -> {
            String string2 = contentMap.put(tc.name(), value);
        });
    }

    static /* synthetic */ boolean access$0() {
        return MakefileJinjaOptions.True();
    }

    public static enum CMakeOpts implements DefaultSupplier,
    FilteredOption
    {
        CMAKE_EXE_PATH(MakefileJinjaOptions::access$0),
        CMAKE_EXE_PATH_WIN(HostUtils::isWindows),
        CMAKE_EXE_PATH_OSX(HostUtils::isOSX),
        CMAKE_EXE_PATH_LINUX(HostUtils::isLinux);

        private final BooleanSupplier filter;

        @Override
        public BooleanSupplier filter() {
            return this.filter;
        }

        private CMakeOpts(BooleanSupplier filter) {
            this.filter = filter;
        }
    }

    public static interface DefaultSupplier {
        default public Supplier<Object> defaultObj() {
            return String::new;
        }

        public String name();
    }

    public static interface FilteredOption {
        public BooleanSupplier filter();
    }

    public static enum MakeOpts implements DefaultSupplier,
    FilteredOption
    {
        MAKE_EXE_PATH(MakefileJinjaOptions::access$0),
        MAKE_EXE_PATH_WIN(HostUtils::isWindows),
        MAKE_EXE_PATH_OSX(HostUtils::isOSX),
        MAKE_EXE_PATH_LINUX(HostUtils::isLinux);

        private final BooleanSupplier filter;

        @Override
        public BooleanSupplier filter() {
            return this.filter;
        }

        private MakeOpts(BooleanSupplier filter) {
            this.filter = filter;
        }
    }

    public static enum NinjaOpts implements DefaultSupplier,
    FilteredOption
    {
        NINJA_EXE_PATH(MakefileJinjaOptions::access$0),
        NINJA_EXE_PATH_WIN(HostUtils::isWindows),
        NINJA_EXE_PATH_OSX(HostUtils::isOSX),
        NINJA_EXE_PATH_LINUX(HostUtils::isLinux);

        private final BooleanSupplier filter;

        @Override
        public BooleanSupplier filter() {
            return this.filter;
        }

        private NinjaOpts(BooleanSupplier filter) {
            this.filter = filter;
        }
    }

    public static enum PostBuildExeOpts implements DefaultSupplier,
    FilteredOption
    {
        POST_BUILD_EXE(MakefileJinjaOptions::access$0),
        POST_BUILD_EXE_WIN(HostUtils::isWindows),
        POST_BUILD_EXE_OSX(HostUtils::isOSX),
        POST_BUILD_EXE_LINUX(HostUtils::isLinux);

        private final BooleanSupplier filter;

        @Override
        public BooleanSupplier filter() {
            return this.filter;
        }

        private PostBuildExeOpts(BooleanSupplier filter) {
            this.filter = filter;
        }
    }

    public static enum PostBuildToolOpts implements DefaultSupplier
    {
        PRE_BUILD_ARGS,
        POST_BUILD_ARGS;

    }

    public static enum ProjectOptions implements DefaultSupplier
    {
        C_SOURCES(SortedArrayList::new),
        CXX_SOURCES(SortedArrayList::new),
        ASM_SOURCES(SortedArrayList::new),
        ALL_SOURCES(SortedArrayList::new),
        EXCLUDED_FILES(SortedArrayList::new),
        USER_LIBS(ArrayList::new),
        SYS_LIBS(ArrayList::new),
        ALL_LIBS(ArrayList::new),
        ALL_LIB_PATHS(ArrayList::new),
        C_CXX_DEFINES(HashMap::new),
        ASM_DEFINES(HashMap::new),
        C_CXX_DEFINE_STR(ArrayList::new),
        ASM_DEFINE_STR(ArrayList::new),
        C_CXX_INCLUDES(ArrayList::new),
        ASM_INCLUDES(ArrayList::new),
        EXT_CFLAGS(ArrayList::new),
        EXT_DEBUG_C_FLAGS(ArrayList::new),
        EXT_RELEASE_C_FLAGS(ArrayList::new),
        EXT_CXX_FLAGS(ArrayList::new),
        EXT_DEBUG_CXX_FLAGS(ArrayList::new),
        EXT_RELEASE_CXX_FLAGS(ArrayList::new),
        EXT_ASM_FLAGS(ArrayList::new),
        EXT_DEBUG_ASM_FLAGS(ArrayList::new),
        EXT_RELEASE_ASM_FLAGS(ArrayList::new),
        EXT_LD_FLAGS(ArrayList::new),
        EXT_DEBUG_LD_FLAGS(ArrayList::new),
        EXT_RELEASE_LD_FLAGS(ArrayList::new),
        PROJECT_NAME(String::new),
        PKG_PATH(String::new),
        SDK_PATH(String::new),
        COPIED_SDK_PATH(String::new),
        INLCUDED_MAKEFILES(SortedArrayList::new),
        SIMPLICITY_STUDIO_METADATA(String::new),
        PROJECT_PATH(String::new);

        private Supplier<Object> defaultObj;

        private ProjectOptions(Supplier<Object> defaultObj) {
            this.defaultObj = defaultObj;
        }

        @Override
        public Supplier<Object> defaultObj() {
            return this.defaultObj;
        }
    }

    public static enum SolutionOptions implements DefaultSupplier
    {
        SOLUTION_NAME(String::new),
        PROJECT_MAKEFILES(ArrayList::new),
        SIMPLICITY_STUDIO_METADATA(String::new);

        final Supplier<Object> defaultObj;

        private SolutionOptions(Supplier<Object> defaultObj) {
            this.defaultObj = defaultObj;
        }

        @Override
        public Supplier<Object> defaultObj() {
            return this.defaultObj;
        }
    }

    public static class SortedArrayList<T>
    extends ArrayList<T> {
    }

    public static enum ToolchainOpts implements DefaultSupplier,
    FilteredOption
    {
        TOOLCHAIN_DIR(MakefileJinjaOptions::access$0),
        TOOLCHAIN_DIR_WIN(HostUtils::isWindows),
        TOOLCHAIN_DIR_OSX(HostUtils::isOSX),
        TOOLCHAIN_DIR_LINUX(HostUtils::isLinux);

        private final BooleanSupplier filter;

        @Override
        public BooleanSupplier filter() {
            return this.filter;
        }

        private ToolchainOpts(BooleanSupplier filter) {
            this.filter = filter;
        }
    }
}

