/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.google.common.collect.ImmutableSet;
import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ISelectableDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.type.ExternalProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectToolOptionHandler;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileExternalProjectType;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileSolutionOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileTemplates;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MakefileProjectType
extends ExternalProjectType {
    private static final ImmutableSet<String> MAKEFILE_EXTENSIONS = ImmutableSet.of((Object)"mak", (Object)"Makefile", (Object)"makefile");
    public static final String IDE_COMPATIBILITY_ID = "makefile-ide";

    @Override
    public Collection<String> matchingKeywords() {
        return Arrays.asList("makefile");
    }

    @Override
    public double getApplicability(IPath projLoc) throws CoreException {
        String ext = projLoc.getFileExtension();
        if (MAKEFILE_EXTENSIONS.contains((Object)ext)) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return false;
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity project) {
        if (!(project instanceof IExternalProjectEntity)) {
            throw new IllegalArgumentException("Makefile generation requires an IExternalProjectEntity");
        }
        return new MakefileOperationHandler((IExternalProjectEntity)project);
    }

    @Override
    public IExternalType getExternalType() {
        return new MakefileExternalProjectType();
    }

    @Override
    public ISolutionEngineOperationHandler createSolutionEngineOperationHandler(ISolutionEntity solution) {
        return new MakefileSolutionOperationHandler(solution);
    }

    @Override
    public Collection<File> getSupportedSolutions(ISolutionDescriptor slnDesc, File directory, String baseName) {
        return List.of(new File(directory, baseName + ".solution.Makefile"));
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (IProjectToolOptionHandler.class.equals(clazz)) {
            return clazz.cast(new MakeFileToolOptionHandler());
        }
        if (IProjectTypeInfo.class.equals(clazz)) {
            return clazz.cast(new MakefileProjectTypeInfo());
        }
        return super.getAdapter(clazz);
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor desc, File directory, String baseName) {
        List<File> supportedFiles = MakefileTemplates.instance().getAllAllowedTemplates(desc).map(FileUtils::getExtension).map(e -> new File(directory, baseName + "." + e)).collect(Collectors.toList());
        return supportedFiles;
    }

    private class MakeFileToolOptionHandler
    implements IProjectToolOptionHandler {
        private MakeFileToolOptionHandler() {
        }

        @Override
        public Collection<IGenericOptionMappingRegistry> getGenericOptionMappingRegistry(IProjectDescriptor proj, ISelectableDescriptor context) {
            return MakefileTemplates.instance().getMappingRegistries(proj, context);
        }
    }

    protected class MakefileProjectTypeInfo
    implements IProjectTypeInfo {
        protected MakefileProjectTypeInfo() {
        }

        @Override
        public String ideCompatibilityId() {
            return MakefileProjectType.IDE_COMPATIBILITY_ID;
        }
    }
}

