/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.BaseExternalSolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionConfigProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.BaseSolutionConfigEngineOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.CreateSolutionConfigOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.ResetSolutionModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetGeneralPropertyOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetNameOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPrebuildStepOperation;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGenerator;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGeneratorFactory;
import com.silabs.ss.framework.project.api.generator.template.TemplateContribution;
import com.silabs.ss.framework.project.api.generator.template.TemplateManager;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileJinjaOptions;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileSolutionMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileTemplates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakefileSolutionOperationHandler
extends BaseExternalSolutionEngineOperationHandler
implements ISolutionEngineOperationHandler {
    private final Map<String, Object> slnContentMap = new HashMap<String, Object>();
    private MakefileSolutionMetadataHandler metadata;
    private File outputLoc;
    private static final String PROJECT_ID = "%%project%%";
    private final Map<String, Map<String, Object>> configContentMap = new HashMap<String, Map<String, Object>>();
    private String firstConfig = "%%project%%";
    private String preferredConfig;

    private void setString(MakefileJinjaOptions.SolutionOptions opt, String value) {
        this.slnContentMap.put(opt.name(), value);
    }

    public MakefileSolutionOperationHandler(ISolutionEntity solution) {
        super(solution);
    }

    @Override
    public void load() throws CoreException {
        try {
            this.setString(MakefileJinjaOptions.SolutionOptions.SOLUTION_NAME, this.getSolutionEntity().getName());
            this.slnContentMap.put(MakefileJinjaOptions.SolutionOptions.PROJECT_MAKEFILES.name(), new LinkedHashSet());
            this.outputLoc = this.getSolutionEntity().getInstallationPath().removeFileExtension().removeFileExtension().addFileExtension("solution.Makefile").toFile();
            this.metadata = MakefileSolutionMetadataHandler.forWriting(this.slnContentMap, this.outputLoc);
            this.metadata.solution().clean();
            this.metadata.solution().model().setName(this.getSolutionEntity().getName());
            MakefileJinjaOptions.setupToolsInfoData(null, this.slnContentMap);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to generate makefile output!", (Throwable)e);
        }
    }

    @Override
    public void commit() throws CoreException {
        try {
            this.metadata.write();
            this.finalizeOptionMap();
            ITemplateGenerator generator = TemplateManager.currentTemplateFactory().map(ITemplateGeneratorFactory::make).orElseThrow(() -> Activator.reporter.newCoreException("Failed to generate makefiles using Templating engine!"));
            MakefileJinjaOptions.allSolutionOptions().map(opt -> new TemplateContribution(opt.name(), this.slnContentMap.getOrDefault(opt.name(), opt.defaultObj().get()), 0)).forEachOrdered(arg_0 -> ((ITemplateGenerator)generator).add(arg_0));
            File slnTmpl = (File)MakefileTemplates.instance().solutionTemplate(this.getSolutionEntity()).unwrapOrThrow(e -> e);
            String content = generator.generateContent(slnTmpl.toPath());
            this.outputLoc.getParentFile().mkdirs();
            FileUtils.writeFileContents((File)this.outputLoc, (String)content);
        }
        catch (IOException e2) {
            throw Activator.reporter.newCoreException("Failed to generate makefile output!", (Throwable)e2);
        }
    }

    private void finalizeOptionMap() {
        if (this.preferredConfig == null) {
            this.preferredConfig = this.firstConfig;
        }
        this.slnContentMap.putAll(this.configContentMap.getOrDefault(this.preferredConfig, Collections.emptyMap()));
    }

    private void setConfigString(BaseSolutionConfigEngineOperation op, Enum<?> opt, String value) {
        String configId = op.solutionConfig() == null ? PROJECT_ID : op.solutionConfig();
        this.configContentMap.computeIfAbsent(configId, k -> new LinkedHashMap()).put(opt.name(), value);
    }

    @Override
    public void handleAddSolutionModuleReferenceOperation(AddSolutionModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionModuleReference ref = SolutionModelFactory.eINSTANCE.createMSolutionModuleReference();
        ref.setId(operation.moduleId());
        this.metadata.solution().model().getSolutionModuleReferences().add((Object)ref);
    }

    @Override
    public void handleAddSolutionDefinedModuleOperation(AddSolutionDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.solution().model().getSolutionDefinedModules().add((Object)operation.module());
    }

    @Override
    public void handleSetSolutionConfigPrebuildStepOperation(SetSolutionConfigPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.setConfigString(operation, MakefileJinjaOptions.PostBuildToolOpts.PRE_BUILD_ARGS, this.substitutePostBuildVariables(operation.buildStep()));
    }

    @Override
    public void handleSetSolutionConfigPostbuildStepOperation(SetSolutionConfigPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        this.setConfigString(operation, MakefileJinjaOptions.PostBuildToolOpts.POST_BUILD_ARGS, this.substitutePostBuildVariables(operation.buildStep()));
    }

    @Override
    public String lookupCommanderVariable() {
        return "@\"$(POST_BUILD_EXE)\"";
    }

    @Override
    public void handleSetNameOperation(SetNameOperation operation, IProgressMonitor monitor) throws CoreException {
        this.setString(MakefileJinjaOptions.SolutionOptions.SOLUTION_NAME, operation.name());
        this.metadata.solution().model().setName(operation.name());
    }

    @Override
    public void handleAddProjectOperation(AddSolutionProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        String location = operation.location();
        String defaultFileName = operation.projectName() + ".Makefile";
        Path locationPath = location == null ? Path.of(defaultFileName, new String[0]) : (location.endsWith(".Makefile") ? Path.of(location, new String[0]) : Path.of(location, new String[0]).resolve(defaultFileName));
        ProjectMakefiles project = new ProjectMakefiles(operation.projectName(), locationPath);
        ((Collection)this.slnContentMap.get(MakefileJinjaOptions.SolutionOptions.PROJECT_MAKEFILES.name())).add(project);
    }

    @Override
    public void handleAddSolutionConfigProjectOperation(AddSolutionConfigProjectOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleCreateSolutionConfigOperation(CreateSolutionConfigOperation operation, IProgressMonitor monitor) throws CoreException {
        if (PROJECT_ID.equals(this.firstConfig)) {
            this.firstConfig = operation.solutionConfig();
        }
    }

    @Override
    public void handleSetGeneralPropertyOperation(SetGeneralPropertyOperation operation, IProgressMonitor monitor) throws CoreException {
        if (operation.key().contains("activeDebugGroup")) {
            this.preferredConfig = operation.value();
        }
    }

    @Override
    public void handleResetSolutionModuleReferencesOperation(ResetSolutionModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    static class ProjectMakefiles {
        final String id;
        final String name;
        final String dir;
        final String path;

        public ProjectMakefiles(String id, Path locationPath) {
            this.id = id;
            this.name = this.pathAsString(locationPath.getFileName());
            this.dir = this.pathAsString(locationPath.getParent());
            this.path = this.pathAsString(locationPath);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDir() {
            return this.dir;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProjectMakefiles)) {
                return false;
            }
            return Objects.equals(this.id, ((ProjectMakefiles)obj).id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        private String pathAsString(Path path) {
            if (path == null) {
                return "";
            }
            return path.toString().replace("\\", "/");
        }
    }
}

