/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectCopiedFiles;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectModuleHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPathVariablesController;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPropertiesHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.framework.project.internal.core.type.ses.SESModelUtils;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfiguration;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESProject;
import java.util.List;

public class SESMetadataHandler
extends ExternalProjectMetadataHandler<MProject, SESMetadataHandler> {
    private ExternalProjectModuleHandler modules;
    private ExternalProjectCopiedFiles copiedFiles;
    private ExternalProjectPropertiesHandler properties;
    private ExternalProjectPathVariablesController variables;
    private SESProject sesProject;

    public SESMetadataHandler(SESProject sesProject) {
        this.sesProject = sesProject;
    }

    public ExternalProjectModuleHandler modules() {
        return this.modules;
    }

    public ExternalProjectCopiedFiles copiedFiles() {
        return this.copiedFiles;
    }

    public ExternalProjectPropertiesHandler properties() {
        return this.properties;
    }

    public ExternalProjectPathVariablesController variables() {
        return this.variables;
    }

    @Override
    protected void loadMetadataHandlers(List<IExternalProjectMetadata<MProject>> handlers) {
        this.modules = new ExternalProjectModuleHandler();
        this.copiedFiles = new ExternalProjectCopiedFiles();
        this.properties = new ExternalProjectPropertiesHandler();
        this.variables = new ExternalProjectPathVariablesController();
        handlers.add(this.modules);
        handlers.add(this.copiedFiles);
        handlers.add(this.properties);
        handlers.add(this.variables);
    }

    @Override
    protected void writeStringContent(String metadata) {
        SESConfiguration studio_config = SESModelUtils.findOrCreateConfiguration("Simplicity_Configuration_Content", this.sesProject);
        studio_config.setSilicon_labs_metadata(metadata);
    }

    @Override
    protected String getStringContent() {
        SESConfiguration studio_config = SESModelUtils.findConfiguration("Simplicity_Configuration_Content", this.sesProject);
        if (studio_config == null) {
            return "";
        }
        return studio_config.getSilicon_labs_metadata();
    }
}

