/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.slsproj;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.solution.ISolutionDescriptor;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.type.ExternalProjectType;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.core.type.SimplicityIDEProjectTypeInfo;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.Toolchain;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainUtils;
import com.silabs.ss.framework.project.internal.api.core.external.impl.SlsProjExternalProjectType;
import com.silabs.ss.framework.project.internal.core.type.slsproj.SlsprojProjectOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.slsproj.SlsprojSolutionOperationHandler;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.compatibility.ICompatibilityQuery;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SlsprojProjectType
extends ExternalProjectType {
    public static final String ID = "com.silabs.project.slsproj";
    public static final String SLSPROJ_FILE_EXTENSION = "slsproj";
    public static final String SLSPROJ_SOLUTION_EXTENSION = "solution";
    private final IToolchainDescriptor[] tcStubs;

    public SlsprojProjectType() {
        this.setName(SLSPROJ_FILE_EXTENSION);
        this.tcStubs = ToolchainUtils.findToolchainStubs();
    }

    @Override
    public double getApplicability(IPath projectLocation) throws CoreException {
        if (Objects.equals(projectLocation.getFileExtension(), SLSPROJ_FILE_EXTENSION)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Collection<File> getSupportedFiles(IProjectDescriptor projDesc, File directory, String baseName) {
        if (!RuntimeUtils.isJUnitRunning() && !RuntimeUtils.isPlatformPDELaunch()) {
            return Collections.emptyList();
        }
        String core = (String)projDesc.getProperty(ProjectProperties.ALLOWED_CORE_ARCHITECTURE);
        if (!"ARM".equals(core) && !"8051".equals(core)) {
            return Collections.emptyList();
        }
        Collection tcCompat = (Collection)projDesc.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        if (!tcCompat.isEmpty()) {
            ICompatibilityQuery query = Compatibility.fromGrammar((IRegistry)Toolchain.manager(), (Collection)tcCompat);
            boolean isCompat = Stream.of(this.tcStubs).anyMatch(arg_0 -> ((ICompatibilityQuery)query).isCompatibleWith(arg_0));
            if (!isCompat) {
                return Collections.emptyList();
            }
        }
        if (tcCompat.size() == 1 && !TextUtils.isEmpty((String)((String)tcCompat.iterator().next()))) {
            baseName = (String)baseName + "_" + String.valueOf(tcCompat.iterator().next());
        }
        return Arrays.asList(new File(directory, (String)baseName + ".slsproj"));
    }

    @Override
    public Collection<File> getSupportedSolutions(ISolutionDescriptor slnDesc, File directory, String baseName) {
        if (!RuntimeUtils.isJUnitRunning() && !RuntimeUtils.isPlatformPDELaunch()) {
            return Collections.emptyList();
        }
        return Arrays.asList(new File(directory, baseName + ".solution"));
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (IProjectTypeInfo.class.equals(clazz)) {
            return clazz.cast(new SimplicityIDEProjectTypeInfo());
        }
        return super.getAdapter(clazz);
    }

    @Override
    public IProjectEngineOperationHandler createProjectEngineOperationHandler(IProjectEntity project) {
        return new SlsprojProjectOperationHandler((IExternalProjectEntity)project);
    }

    @Override
    public ISolutionEngineOperationHandler createSolutionEngineOperationHandler(ISolutionEntity solution) {
        return new SlsprojSolutionOperationHandler(solution);
    }

    @Override
    public boolean toolchainSupportsProject(IToolchainDescriptor toolchain, IProjectDescriptor desc) {
        return true;
    }

    @Override
    public IExternalType getExternalType() {
        return new SlsProjExternalProjectType();
    }

    @Override
    public boolean supportsMultipleConfigurations() {
        return true;
    }
}

