/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.vscodecmake;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.framework.project.internal.core.type.generic.NonTemplateFileGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.INonTemplateContext;
import com.silabs.ss.framework.project.internal.core.type.generic.model.NonTemplateFileContext;
import com.silabs.ss.framework.project.internal.core.type.vscodecmake.config.VscodeProjectConfiguration;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.IToolsInfoService;
import com.silabs.ss.platform.api.descriptor.core.toolsinfoservice.model.ToolInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;

public class ConfigFileGenerator
extends NonTemplateFileGenerator {
    private static final String CONFIG_FILE_NAME = "vscode.conf";
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public void generate(INonTemplateContext icontext) throws CoreException {
        if (!(icontext instanceof NonTemplateFileContext)) {
            return;
        }
        NonTemplateFileContext projectContext = (NonTemplateFileContext)icontext;
        IProjectEntity entity = projectContext.getExternalProject();
        if (entity == null) {
            return;
        }
        try {
            String fileExtension = entity.getInstallationPath().getFileExtension();
            if (fileExtension != null && fileExtension.equalsIgnoreCase("cmake")) {
                VscodeProjectConfiguration projectConfig = new VscodeProjectConfiguration();
                IToolsInfoService service = projectContext.getToolsInfoService();
                List<String> resolverList = List.of("commander", "studio", "make", "segger", "cmake");
                Map toolInfo = service.getToolsInfo(resolverList);
                IToolchainDescriptor toolchain = StudioExporterUtils.findToolchain(entity);
                projectConfig.setTools(this.toolInfoMappper(toolInfo, toolchain));
                projectConfig.setDebugPartName(projectContext.getDebugPartName());
                projectConfig.setProjectName(projectContext.getProjectName());
                String configString = this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).writerWithDefaultPrettyPrinter().writeValueAsString((Object)projectConfig);
                File configFile = entity.getProjectPath().append(CONFIG_FILE_NAME).toFile();
                configFile.getParentFile().mkdirs();
                FileUtils.writeFileContents((File)configFile, (String)configString);
            }
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to generate output file!", (Throwable)e);
        }
    }

    private Map<String, String> toolInfoMappper(Map<String, ToolInfo> toolInfoMap, IToolchainDescriptor toolchain) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (toolchain != null) {
            output.put("toolchain", this.getVersion(toolchain.getVersionString()));
        }
        toolInfoMap.forEach((k, v) -> {
            String string = output.put((String)k, this.getVersion((ToolInfo)v));
        });
        return output;
    }

    private String getVersion(ToolInfo tInfo) {
        String version = tInfo.version();
        return this.getVersion(version);
    }

    private String getVersion(String version) {
        if (TextUtils.isEmpty((String)version)) {
            return "0.0.0";
        }
        return version;
    }
}

