/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.vscodecmake;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.NonTemplateFileGenerator;
import com.silabs.ss.framework.project.internal.core.type.generic.model.INonTemplateContext;
import com.silabs.ss.framework.project.internal.core.type.generic.model.NonTemplateSolutionFileContext;
import com.silabs.ss.framework.project.internal.core.type.vscodecmake.config.VscodeSolutionConfiguration;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SolutionConfigFileGenerator
extends NonTemplateFileGenerator {
    private static final String DEFAULT_CONFIG_GROUP = "default_config";
    private static final String SOLUTION_CONFIG = "vscsolution.conf";
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public void generate(INonTemplateContext context) throws CoreException {
        try {
            NonTemplateSolutionFileContext solutionContext = (NonTemplateSolutionFileContext)context;
            IPath installPath = solutionContext.getSolution().getSolutionPath().removeLastSegments(1);
            installPath.toFile().mkdirs();
            VscodeSolutionConfiguration config = new VscodeSolutionConfiguration();
            config.setDebugConfigGroup(DEFAULT_CONFIG_GROUP);
            config.setPostBuild(solutionContext.getPostBuild());
            config.setSolutionName(solutionContext.getSolutionName());
            config.setSubProjectList(solutionContext.getSubProjectList());
            String configString = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)config);
            File configFile = installPath.append(SOLUTION_CONFIG).toFile();
            FileUtils.writeFileContents((File)configFile, (String)configString);
        }
        catch (Exception e) {
            throw Activator.reporter.newCoreException("Failed to generate output file!", (Throwable)e);
        }
    }
}

