/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger.internal;

import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;

public class JaegerGrpcSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    @Override
    public String getName() {
        return "jaeger";
    }

    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        Duration timeout2;
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout2 = config.getDuration("otel.exporter.jaeger.timeout")) != null) {
            builder.setTimeout(timeout2);
        }
        return builder.build();
    }
}

