/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.ImmutableSpanContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributeUtil;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkSpan;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkSpanBuilder
implements SpanBuilder {
    private final String spanName;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final TracerSharedState tracerSharedState;
    private final SpanLimits spanLimits;
    @Nullable
    private Context parent;
    private SpanKind spanKind = SpanKind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<LinkData> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;

    SdkSpanBuilder(String spanName, InstrumentationScopeInfo instrumentationScopeInfo, TracerSharedState tracerSharedState, SpanLimits spanLimits) {
        this.spanName = spanName;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerSharedState = tracerSharedState;
        this.spanLimits = spanLimits;
    }

    public SpanBuilder setParent(Context context) {
        if (context == null) {
            return this;
        }
        this.parent = context;
        return this;
    }

    public SpanBuilder setNoParent() {
        this.parent = Context.root();
        return this;
    }

    public SpanBuilder setSpanKind(SpanKind spanKind) {
        if (spanKind == null) {
            return this;
        }
        this.spanKind = spanKind;
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        this.addLink(LinkData.create(spanContext));
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addLink(LinkData.create(spanContext, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerLink(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    private void addLink(LinkData link) {
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<LinkData>(this.spanLimits.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.spanLimits.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(link);
    }

    public SpanBuilder setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey((String)key), value);
    }

    public SpanBuilder setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.attributes().put(key, value);
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        if (startTimestamp < 0L || unit == null) {
            return this;
        }
        this.startEpochNanos = unit.toNanos(startTimestamp);
        return this;
    }

    public Span startSpan() {
        Context parentContext = this.parent == null ? Context.current() : this.parent;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        IdGenerator idGenerator = this.tracerSharedState.getIdGenerator();
        String spanId = idGenerator.generateSpanId();
        String traceId = !parentSpanContext.isValid() ? idGenerator.generateTraceId() : parentSpanContext.getTraceId();
        List<LinkData> immutableLinks = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Attributes immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        SamplingResult samplingResult = this.tracerSharedState.getSampler().shouldSample(parentContext, traceId, this.spanName, this.spanKind, immutableAttributes, immutableLinks);
        SamplingDecision samplingDecision = samplingResult.getDecision();
        TraceState samplingResultTraceState = samplingResult.getUpdatedTraceState(parentSpanContext.getTraceState());
        SpanContext spanContext = ImmutableSpanContext.create((String)traceId, (String)spanId, (TraceFlags)(SdkSpanBuilder.isSampled(samplingDecision) ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)samplingResultTraceState, (boolean)false, (boolean)this.tracerSharedState.isIdGeneratorSafeToSkipIdValidation());
        if (!SdkSpanBuilder.isRecording(samplingDecision)) {
            return Span.wrap((SpanContext)spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            samplingAttributes.forEach((key, value) -> this.attributes().put(key, value));
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return SdkSpan.startSpan(spanContext, this.spanName, this.instrumentationScopeInfo, this.spanKind, parentSpan, parentContext, this.spanLimits, this.tracerSharedState.getActiveSpanProcessor(), this.tracerSharedState.getClock(), this.tracerSharedState.getResource(), recordedAttributes, immutableLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private AttributesMap attributes() {
        AttributesMap attributes = this.attributes;
        if (attributes == null) {
            attributes = this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
        }
        return attributes;
    }

    static boolean isRecording(SamplingDecision decision) {
        return SamplingDecision.RECORD_ONLY.equals((Object)decision) || SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    static boolean isSampled(SamplingDecision decision) {
        return SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }
}

