/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.lua.library;

import com.google.common.collect.ImmutableMap;
import com.silabs.ss.platform.api.rcp.core.BundleUtils;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import com.silabs.ss.support.api.lua.LuaSandbox;
import com.silabs.ss.support.internal.lua.LuaSupportActivator;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.luaj.vm2.LuaValue;
import org.osgi.framework.Bundle;

public final class LuaLibraryLoader {
    private LuaLibraryLoader() {
    }

    private static Path get(String relPath) throws IOException {
        return BundleUtils.getBundleContentPath((Bundle)LuaSupportActivator.getContext().getBundle(), (IPath)IPathUtils.createPath((String)("lua/" + relPath)), (Map)ImmutableMap.of()).toFile().toPath();
    }

    public static void installIntoSandbox(LuaSandbox sandbox, String namespace, String relPath) {
        try {
            Path toInstall = LuaLibraryLoader.get(relPath);
            LuaValue libChunk = sandbox.load(toInstall);
            sandbox.addCustomLuaLibrary(namespace, libChunk);
        }
        catch (IOException iOException) {
            throw new RuntimeException("LuaLibraryLoader attempted to load non-existent internal library " + relPath);
        }
    }
}

