/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti;

import com.silabs.pti.CommandLine;
import com.silabs.pti.OutputMap;
import com.silabs.pti.adapter.Adapter;
import com.silabs.pti.adapter.AdapterPort;
import com.silabs.pti.adapter.DebugChannelFramer;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionListener;
import com.silabs.pti.adapter.IConnectivityLogger;
import com.silabs.pti.adapter.TimeSynchronizer;
import com.silabs.pti.debugchannel.DebugMessageConnectionListener;
import com.silabs.pti.debugchannel.TextConnectionListener;
import com.silabs.pti.filter.CliDebugMessageFilter;
import com.silabs.pti.format.FileFormat;
import com.silabs.pti.util.LineTerminator;
import com.silabs.pti.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Scanner;

public class Interactive {
    private String prompt = "$";
    private FileFormat formatType = FileFormat.LOG;
    private File out = new File("packet-trace.log");
    private IConnection debugConnection = null;
    private IConnection cliConnection = null;
    private String host = null;
    private OutputMap<?> cliOutputMap = null;
    private OutputMap<?> captureOutputMap = null;
    private DebugMessageConnectionListener<?> connectionListener = null;
    private IConnectionListener cliConnectionListener = null;
    private String setChannelCommand = "set_channel";
    private String radioOnCommand = "set_mac_idle_mode";
    private int cliPort = AdapterPort.SERIAL0.defaultPort();
    private final IConnectivityLogger logger;
    private final TimeSynchronizer timeSync;
    private CliDebugMessageFilter filter = null;

    private Interactive(CommandLine cli, TimeSynchronizer timeSync) {
        if (cli.hostnames().length > 0) {
            this.host = cli.hostnames()[0];
        }
        this.logger = cli;
        this.timeSync = timeSync;
        this.cliOutputMap = new OutputMap();
        this.captureOutputMap = new OutputMap();
        this.filter = cli.filter();
    }

    public static int runInteractive(CommandLine cli, TimeSynchronizer timeSync) {
        String cmd;
        Scanner scanner = new Scanner(new InputStreamReader(System.in));
        System.out.println("Entering interactive mode. Use 'help' to get help.");
        Interactive in = new Interactive(cli, timeSync);
        do {
            in.printPompt();
            try {
                cmd = scanner.nextLine();
            }
            catch (Exception e) {
                cmd = null;
            }
        } while (cmd != null && (cmd.trim().length() == 0 || !in.runCommand(cmd)));
        return 0;
    }

    private List<Method> getCliMethods() {
        ArrayList<Method> l = new ArrayList<Method>();
        for (Method m : this.getClass().getMethods()) {
            if (m.getAnnotation(Cli.class) == null) continue;
            l.add(m);
        }
        Collections.sort(l, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return l;
    }

    private void printPompt() {
        if (this.connectionListener != null) {
            System.out.print("[" + this.connectionListener.count() + " events from " + this.host + "]");
        }
        System.out.print(this.prompt + " ");
    }

    private boolean runCommand(String cmd) {
        String[] cmdLine = cmd.split("\\s++");
        if (cmdLine.length == 0) {
            return false;
        }
        for (Method m : this.getCliMethods()) {
            if (!cmdLine[0].equalsIgnoreCase(m.getName())) continue;
            Object[] args = null;
            if (cmdLine.length > 1) {
                args = new Object[]{Arrays.copyOfRange(cmdLine, 1, cmdLine.length)};
            }
            try {
                Object ret;
                if (m.isVarArgs() && args == null) {
                    args = new Object[]{new String[0]};
                }
                if ((ret = m.invoke((Object)this, args)) instanceof Boolean) {
                    return (Boolean)ret;
                }
                return false;
            }
            catch (Exception e) {
                System.out.println("Error executing: " + cmd);
                e.printStackTrace();
                return false;
            }
        }
        System.out.println("Invalid command: " + cmd);
        return false;
    }

    @Cli(help="Quits the interactive application")
    public boolean quit() {
        return true;
    }

    @Cli(help="Prints the version")
    public void version() {
        try {
            System.out.println(CommandLine.getVersionString());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    @Cli(help="Clears the filter")
    public void clearFilter() {
        this.filter = null;
    }

    @Cli(help="Sets the filter", args="[EXPRESSION | help]")
    public void filter(String ... args) {
        if ("help".equals(args[0])) {
            System.out.println("Valid expressions:\n" + CliDebugMessageFilter.helpText());
        } else {
            try {
                CliDebugMessageFilter cf;
                this.filter = cf = new CliDebugMessageFilter(args[0]);
            }
            catch (ParseException pe) {
                System.out.println("Filter expression error: " + pe.getMessage());
            }
        }
    }

    @Cli(help="Adds the filter expression with an AND operator", args="EXPRESSION")
    public void andFilter(String ... args) {
        if (this.filter == null) {
            System.out.println("No filter yet. First use 'filter' command.");
        } else {
            try {
                this.filter.andFilter(args[0]);
            }
            catch (ParseException pe) {
                System.out.println("Filter expression error: " + pe.getMessage());
            }
        }
    }

    @Cli(help="Adds the filter expression with an OR operator", args="EXPRESSION")
    public void orFilter(String ... args) {
        if (this.filter == null) {
            System.out.println("No filter yet. First use 'filter' command.");
        } else {
            try {
                this.filter.orFilter(args[0]);
            }
            catch (ParseException pe) {
                System.out.println("Filter expression error: " + pe.getMessage());
            }
        }
    }

    @Cli(help="Prints out the available commands")
    public void help() {
        CharSequence help;
        System.out.println("Valid commands:");
        LinkedHashMap<String, String> cmdsHelp = new LinkedHashMap<String, String>();
        for (Method m : this.getCliMethods()) {
            Cli c = m.getAnnotation(Cli.class);
            help = new StringBuilder();
            ((StringBuilder)help).append("  ");
            ((StringBuilder)help).append(m.getName().toLowerCase());
            if (c.args() != null && c.args().length() > 0) {
                ((StringBuilder)help).append(" ").append(c.args());
            }
            cmdsHelp.put(((StringBuilder)help).toString(), c.help());
        }
        int n = 0;
        for (String key : cmdsHelp.keySet()) {
            if (key.length() <= n) continue;
            n = key.length();
        }
        for (String key : cmdsHelp.keySet()) {
            System.out.print("  ");
            System.out.print(key);
            help = (String)cmdsHelp.get(key);
            if (help == null || ((String)help).length() <= 0) continue;
            for (int i = 0; i < n - key.length(); ++i) {
                System.out.print(" ");
            }
            System.out.print(" - ");
            System.out.println((String)help);
        }
    }

    private void cli(String s) throws IOException {
        if (this.cliConnection == null || !this.cliConnection.isConnected()) {
            try {
                this.cliOutputMap.put(this.host, FileFormat.TEXT.format().createStdoutOutput());
            }
            catch (Exception e) {
                System.err.println("Could not open file: " + this.out.getAbsolutePath());
                e.printStackTrace();
                return;
            }
            this.cliConnectionListener = new TextConnectionListener(this.host, this.cliOutputMap);
            this.cliConnection = Adapter.createConnection(this.host, this.cliPort, this.logger);
            this.cliConnection.connect();
            this.cliConnection.addConnectionListener(this.cliConnectionListener);
        }
        this.cliConnection.send(s + LineTerminator.CRLF);
    }

    @Cli(help="Turns the radio on or off", args="{ on | off }")
    public void radio(String ... ch) {
        if (ch.length > 0) {
            boolean on = ch[0].equalsIgnoreCase("on") || ch[0].equalsIgnoreCase("1");
            String cmd = on ? this.radioOnCommand + " 1" : this.radioOnCommand + " 0";
            try {
                this.cli(cmd);
            }
            catch (Exception e) {
                System.out.println("ERROR: could not toggle radio: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Cli(help="Sets the channel", args="CHANNEL")
    public void channel(String ... ch) {
        if (ch.length > 0) {
            try {
                this.cli(this.setChannelCommand + " " + ch[0]);
            }
            catch (Exception e) {
                System.out.println("ERROR: could not set channel: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Cli(help="Sets the TCP/IP port to use for the CLI interaction", args="PORT")
    public void cli_port(String ... port) {
        if (port.length > 0) {
            try {
                this.cliPort = MiscUtil.parseInt(port[0]);
                if (this.cliConnection != null) {
                    this.cliConnection.close();
                    this.cliConnection = null;
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid format: " + port[0]);
            }
        }
        System.out.println("Cli port is: " + this.cliPort);
    }

    @Cli(help="Sets the 'set channel' command", args="SETCHANNELCMD")
    public void channel_command(String ... chcmd) {
        if (chcmd.length > 0) {
            this.setChannelCommand = chcmd[0];
        }
        System.out.println("Channel command is: '" + this.setChannelCommand + "'");
    }

    @Cli(help="Sets the enable radio command", args="SETRADIOCMD")
    public void radio_command(String ... chcmd) {
        if (chcmd.length > 0) {
            this.radioOnCommand = chcmd[0];
        }
        System.out.println("Radio command is: '" + this.radioOnCommand + "'");
    }

    @Cli(help="Sets the prompt", args="PROMPT")
    public void prompt(String ... s) {
        if (s.length > 0) {
            this.prompt = s[0];
        }
    }

    @Cli(help="Shows or sets the output file for captured data", args="[FILENAME]")
    public void file(String ... s) {
        if (s.length > 0) {
            this.out = new File(s[0]);
        }
        System.out.println("Output file: " + this.out.getAbsolutePath());
    }

    @Cli(help="Sends a command", args="COMMAND")
    public void send(String ... ch) {
        if (ch.length > 0) {
            Object command = "";
            for (String a : ch) {
                command = (String)command + a + " ";
            }
            try {
                this.cli((String)command);
            }
            catch (Exception e) {
                System.out.println("ERROR: could not send command: " + (String)command);
                e.printStackTrace();
            }
        }
    }

    @Cli(help="Reconnects to the same host as previous connect command.")
    public void reconnect() {
        if (this.debugConnection != null) {
            this.debugConnection.close();
            this.debugConnection = null;
        }
        if (this.host == null) {
            System.err.println("You should first use 'connect' command at least once.");
            return;
        }
        this.debugConnection = Adapter.createConnection(this.host, AdapterPort.DEBUG.defaultPort(), this.logger);
        try {
            this.debugConnection.connect();
        }
        catch (Exception e) {
            System.out.println("ERROR: could not connect: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Cli(help="Connects to a specified hostname or IP address.", args="HOSTNAME")
    public void connect(String ... s) {
        if (this.debugConnection != null) {
            this.debugConnection.close();
            this.debugConnection = null;
        }
        if (s.length < 1) {
            System.err.println("Missing argument: hostname.");
            return;
        }
        this.host = s[0];
        this.debugConnection = Adapter.createConnection(this.host, AdapterPort.DEBUG.defaultPort(), this.logger);
        try {
            this.debugConnection.connect();
        }
        catch (Exception e) {
            System.out.println("ERROR: could not connect: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Cli(help="Closes the connection.")
    public void close() {
        if (this.debugConnection != null) {
            if (this.connectionListener != null) {
                this.debugConnection.removeConnectionListener(this.connectionListener);
                this.connectionListener = null;
            }
            if (this.captureOutputMap != null) {
                this.captureOutputMap.closeAndClear();
                this.captureOutputMap = null;
            }
            this.debugConnection.close();
            this.debugConnection = null;
        }
        if (this.cliConnection != null) {
            this.cliConnection.close();
            this.cliConnection = null;
        }
    }

    @Cli(help="Starts or stops capture", args="start|stop")
    public void capture(String ... s) {
        boolean isStart;
        if (s.length == 0) {
            System.err.println("Expecting 'start' or 'stop'.");
            return;
        }
        if ("start".equalsIgnoreCase(s[0])) {
            isStart = true;
        } else if ("stop".equalsIgnoreCase(s[0])) {
            isStart = false;
        } else {
            System.err.println("Expecting 'start' or 'stop'.");
            return;
        }
        if (isStart && this.debugConnection == null) {
            System.err.println("You must connect first.");
            return;
        }
        if (isStart) {
            if (this.captureOutputMap != null) {
                System.err.println("Already capturing.");
                return;
            }
            DebugChannelFramer f = new DebugChannelFramer(true);
            this.debugConnection.setFramers(f, f);
            try {
                this.captureOutputMap.put(this.host, this.formatType.format().createOutput(this.out, true));
            }
            catch (Exception e) {
                System.err.println("Could not open file: " + this.out.getAbsolutePath());
                e.printStackTrace();
                return;
            }
            this.connectionListener = new DebugMessageConnectionListener(this.formatType.format(), this.host, this.captureOutputMap, this.timeSync);
            this.connectionListener.setFilter(this.filter);
            this.debugConnection.addConnectionListener(this.connectionListener);
        } else {
            try {
                this.captureOutputMap.closeAndClear();
                this.captureOutputMap = null;
                this.debugConnection.removeConnectionListener(this.connectionListener);
                this.connectionListener = null;
            }
            catch (NullPointerException e) {
                System.err.println("Stream already closed");
            }
        }
    }

    @Cli(help="Sets the format of the capture file", args="[raw|log|text]")
    public void format(String ... s) {
        if (s.length > 0) {
            try {
                this.formatType = FileFormat.valueOf(s[0].toUpperCase());
                if (this.formatType == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                System.err.println("Invalid file format: " + s[0]);
            }
        }
        System.out.println("Current format: " + this.formatType.name());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Cli {
        public String help() default "";

        public String args() default "";
    }
}

