/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.Backchannel;
import com.silabs.pti.adapter.BufferedNioConnection;
import com.silabs.pti.adapter.Connection;
import com.silabs.pti.adapter.ConnectionType;
import com.silabs.pti.adapter.DualThreadBufferedConnection;
import com.silabs.pti.adapter.IBackchannel;
import com.silabs.pti.adapter.IBackchannelPortMapper;
import com.silabs.pti.adapter.IConnection;
import com.silabs.pti.adapter.IConnectionEnabler;
import com.silabs.pti.adapter.IConnectivityLogger;

public class Adapter {
    private Adapter() {
    }

    public static IConnection createConnection(String host, int port, IConnectivityLogger logger) {
        return Adapter.createConnection(ConnectionType.CLASSIC, host, port, logger);
    }

    public static IConnection createConnection(ConnectionType type, String host, int port, IConnectivityLogger logger) {
        switch (type) {
            case CLASSIC: {
                return new Connection(host, port, logger);
            }
            case BUFFERED_NIO: {
                return new BufferedNioConnection(host, port, logger);
            }
            case DUAL_THREAD_BUFFERED: {
                return new DualThreadBufferedConnection(host, port, logger);
            }
        }
        throw new IllegalArgumentException("Must provide valid connection type.");
    }

    public static IBackchannel createBackchannel(String originatorId, String host, IBackchannelPortMapper portmapper, IConnectionEnabler enabler, IConnectivityLogger logger, ConnectionType debugConnectionType) {
        return new Backchannel(originatorId, host, portmapper, enabler, logger, debugConnectionType);
    }
}

