/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.ILineTerminatingFramer;
import com.silabs.pti.util.LineTerminator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class AsciiFramer
implements ILineTerminatingFramer {
    private LineTerminator lineTerminator;
    private static final String CHARSET = "US-ASCII";
    private final List<Byte> message = new ArrayList<Byte>();
    private boolean ignoreNewline = false;
    private Charset cs;

    public AsciiFramer() {
        this.lineTerminator = LineTerminator.CRLF;
        try {
            this.cs = Charset.forName(CHARSET);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Java error. Not supporting US-ASCII");
        }
    }

    @Override
    public byte[] assembleMessage(byte nextByte) {
        if (nextByte == 10 && this.ignoreNewline) {
            this.ignoreNewline = false;
            return null;
        }
        this.ignoreNewline = nextByte == 13;
        if (nextByte == 13 || nextByte == 10) {
            byte[] ints = new byte[this.message.size()];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = this.message.get(i);
            }
            this.message.clear();
            return ints;
        }
        this.message.add(nextByte);
        return null;
    }

    @Override
    public byte[] flushMessage() {
        if (this.message.size() == 0) {
            return null;
        }
        byte[] ints = new byte[this.message.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = this.message.get(i);
        }
        this.message.clear();
        return ints;
    }

    @Override
    public byte[] frame(byte[] msg) {
        return this.toBytes(this.toString(msg) + this.lineTerminator.terminator());
    }

    @Override
    public byte[] toBytes(String msg) {
        if (msg == null) {
            return null;
        }
        return msg.getBytes(this.cs);
    }

    @Override
    public String toString(byte[] msg) {
        if (msg == null) {
            return null;
        }
        return new String(msg, this.cs);
    }

    @Override
    public LineTerminator lineTerminator() {
        return this.lineTerminator;
    }

    @Override
    public void setLineTerminator(LineTerminator lt) {
        this.lineTerminator = lt;
    }
}

